/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import com.google.common.base.Optional;
import com.yammer.dropwizard.config.LoggingConfiguration;
import com.yammer.dropwizard.config.RequestLogConfiguration;
import com.yammer.dropwizard.jetty.AsyncRequestLog;
import com.yammer.dropwizard.logging.LogbackFactory;
import com.yammer.metrics.core.Clock;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.slf4j.LoggerFactory;

public class RequestLogHandlerFactory {
    private final RequestLogConfiguration config;
    private final String name;

    public RequestLogHandlerFactory(RequestLogConfiguration config, String name) {
        this.config = config;
        this.name = name;
    }

    public boolean isEnabled() {
        return this.config.getConsoleConfiguration().isEnabled() || this.config.getFileConfiguration().isEnabled() || this.config.getSyslogConfiguration().isEnabled();
    }

    public RequestLogHandler build() {
        LoggingConfiguration.SyslogConfiguration syslog;
        LoggingConfiguration.FileConfiguration file;
        Logger logger = (Logger)LoggerFactory.getLogger((String)"http.request");
        logger.setAdditive(false);
        LoggerContext context = logger.getLoggerContext();
        AppenderAttachableImpl appenders = new AppenderAttachableImpl();
        RequestLogLayout layout = new RequestLogLayout();
        layout.start();
        LoggingConfiguration.ConsoleConfiguration console = this.config.getConsoleConfiguration();
        if (console.isEnabled()) {
            ConsoleAppender<ILoggingEvent> appender = LogbackFactory.buildConsoleAppender(console, context, (Optional<String>)Optional.absent());
            appender.stop();
            appender.setLayout((Layout)layout);
            appender.start();
            appenders.addAppender(appender);
        }
        if ((file = this.config.getFileConfiguration()).isEnabled()) {
            FileAppender<ILoggingEvent> appender = LogbackFactory.buildFileAppender(file, context, (Optional<String>)Optional.absent());
            appender.stop();
            appender.setLayout((Layout)layout);
            appender.start();
            appenders.addAppender(appender);
        }
        if ((syslog = this.config.getSyslogConfiguration()).isEnabled()) {
            SyslogAppender appender = LogbackFactory.buildSyslogAppender(syslog, context, this.name + "-requests", (Optional<String>)Optional.absent());
            appender.stop();
            appender.setLayout((Layout)layout);
            appender.start();
            appenders.addAppender((Appender)appender);
        }
        RequestLogHandler handler = new RequestLogHandler();
        handler.setRequestLog((RequestLog)new AsyncRequestLog(Clock.defaultClock(), (AppenderAttachableImpl<ILoggingEvent>)appenders, this.config.getTimeZone()));
        return handler;
    }

    private static class RequestLogLayout
    extends LayoutBase<ILoggingEvent> {
        private RequestLogLayout() {
        }

        public String doLayout(ILoggingEvent event) {
            return event.getFormattedMessage() + CoreConstants.LINE_SEPARATOR;
        }
    }
}

