/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.json;

import ch.qos.logback.classic.Level;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import java.io.IOException;

public class LogbackModule
extends Module {
    public String getModuleName() {
        return "LogbackModule";
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializers((Deserializers)new LogbackDeserializers());
    }

    private static class LogbackDeserializers
    extends Deserializers.Base {
        private LogbackDeserializers() {
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (Level.class.isAssignableFrom(type.getRawClass())) {
                return new LevelDeserializer();
            }
            return super.findBeanDeserializer(type, config, beanDesc);
        }
    }

    private static class LevelDeserializer
    extends JsonDeserializer<Level> {
        private LevelDeserializer() {
        }

        public Level deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            if ("false".equalsIgnoreCase(text)) {
                return Level.OFF;
            }
            if ("true".equalsIgnoreCase(text)) {
                return Level.ALL;
            }
            return Level.toLevel((String)text, (Level)Level.INFO);
        }
    }
}

