/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.db;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yammer.dropwizard.util.Duration;
import com.yammer.dropwizard.validation.ValidationMethod;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class DatabaseConfiguration {
    @NotNull
    @JsonProperty
    private String driverClass = null;
    @NotNull
    @JsonProperty
    private String user = null;
    @JsonProperty
    private String password = "";
    @NotNull
    @JsonProperty
    private String url = null;
    @NotNull
    @JsonProperty
    private ImmutableMap<String, String> properties = ImmutableMap.of();
    @NotNull
    @JsonProperty
    private Duration maxWaitForConnection = Duration.seconds((long)1L);
    @NotNull
    @JsonProperty
    private String validationQuery = "/* Health Check */ SELECT 1";
    @Min(value=1L)
    @Max(value=1024L)
    @JsonProperty
    private int minSize = 1;
    @Min(value=1L)
    @Max(value=1024L)
    @JsonProperty
    private int maxSize = 8;
    @JsonProperty
    private boolean checkConnectionWhileIdle;
    @NotNull
    @JsonProperty
    private Duration checkConnectionHealthWhenIdleFor = Duration.seconds((long)10L);
    @NotNull
    @JsonProperty
    private Duration closeConnectionIfIdleFor = Duration.minutes((long)1L);
    @JsonProperty
    private boolean defaultReadOnly = false;
    @JsonProperty
    private ImmutableList<String> connectionInitializationStatements = ImmutableList.of();
    @JsonProperty
    private boolean autoCommentsEnabled = true;

    public boolean isAutoCommentsEnabled() {
        return this.autoCommentsEnabled;
    }

    public void setAutoCommentsEnabled(boolean autoCommentsEnabled) {
        this.autoCommentsEnabled = autoCommentsEnabled;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ImmutableMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = ImmutableMap.copyOf(properties);
    }

    public Duration getMaxWaitForConnection() {
        return this.maxWaitForConnection;
    }

    public void setMaxWaitForConnection(Duration maxWaitForConnection) {
        this.maxWaitForConnection = maxWaitForConnection;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public boolean isCheckConnectionWhileIdle() {
        return this.checkConnectionWhileIdle;
    }

    public void setCheckConnectionWhileIdle(boolean checkConnectionWhileIdle) {
        this.checkConnectionWhileIdle = checkConnectionWhileIdle;
    }

    public Duration getCheckConnectionHealthWhenIdleFor() {
        return this.checkConnectionHealthWhenIdleFor;
    }

    public void setCheckConnectionHealthWhenIdleFor(Duration checkConnectionHealthWhenIdleFor) {
        this.checkConnectionHealthWhenIdleFor = checkConnectionHealthWhenIdleFor;
    }

    public Duration getCloseConnectionIfIdleFor() {
        return this.closeConnectionIfIdleFor;
    }

    public void setCloseConnectionIfIdleFor(Duration closeConnectionIfIdleFor) {
        this.closeConnectionIfIdleFor = closeConnectionIfIdleFor;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public ImmutableList<String> getConnectionInitializationStatements() {
        return this.connectionInitializationStatements;
    }

    public void setConnectionInitializationStatements(List<String> statements) {
        this.connectionInitializationStatements = ImmutableList.copyOf(statements);
    }

    @ValidationMethod(message=".minSize must be less than or equal to maxSize")
    public boolean isPoolSizedCorrectly() {
        return this.minSize <= this.maxSize;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseConfiguration that = (DatabaseConfiguration)obj;
        return !(this.checkConnectionWhileIdle != that.checkConnectionWhileIdle || this.maxSize != that.maxSize || this.minSize != that.minSize || (this.checkConnectionHealthWhenIdleFor == null ? that.checkConnectionHealthWhenIdleFor != null : !this.checkConnectionHealthWhenIdleFor.equals((Object)that.checkConnectionHealthWhenIdleFor)) || (this.closeConnectionIfIdleFor == null ? that.closeConnectionIfIdleFor != null : !this.closeConnectionIfIdleFor.equals((Object)that.closeConnectionIfIdleFor)) || this.defaultReadOnly != that.defaultReadOnly || (this.driverClass == null ? that.driverClass != null : !this.driverClass.equals(that.driverClass)) || (this.maxWaitForConnection == null ? that.maxWaitForConnection != null : !this.maxWaitForConnection.equals((Object)that.maxWaitForConnection)) || (this.password == null ? that.password != null : !this.password.equals(that.password)) || (this.properties == null ? that.properties != null : !this.properties.equals(that.properties)) || (this.url == null ? that.url != null : !this.url.equals(that.url)) || (this.user == null ? that.user != null : !this.user.equals(that.user)) || (this.validationQuery == null ? that.validationQuery != null : !this.validationQuery.equals(that.validationQuery)) || (this.connectionInitializationStatements == null ? that.connectionInitializationStatements != null : !this.connectionInitializationStatements.equals(that.connectionInitializationStatements)));
    }

    public int hashCode() {
        int result = this.driverClass != null ? this.driverClass.hashCode() : 0;
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.maxWaitForConnection != null ? this.maxWaitForConnection.hashCode() : 0);
        result = 31 * result + (this.validationQuery != null ? this.validationQuery.hashCode() : 0);
        result = 31 * result + this.minSize;
        result = 31 * result + this.maxSize;
        result = 31 * result + (this.checkConnectionWhileIdle ? 1 : 0);
        result = 31 * result + (this.checkConnectionHealthWhenIdleFor != null ? this.checkConnectionHealthWhenIdleFor.hashCode() : 0);
        result = 31 * result + (this.closeConnectionIfIdleFor != null ? this.closeConnectionIfIdleFor.hashCode() : 0);
        result = 31 * result + (this.defaultReadOnly ? 1 : 0);
        result = 31 * result + (this.connectionInitializationStatements != null ? this.connectionInitializationStatements.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("driverClass", (Object)this.driverClass).add("user", (Object)this.user).add("password", (Object)this.password).add("url", (Object)this.url).add("properties", this.properties).add("maxWaitForConnection", (Object)this.maxWaitForConnection).add("validationQuery", (Object)this.validationQuery).add("minSize", this.minSize).add("maxSize", this.maxSize).add("checkConnectionWhileIdle", this.checkConnectionWhileIdle).add("checkConnectionHealthWhenIdleFor", (Object)this.checkConnectionHealthWhenIdleFor).add("closeConnectionIfIdleFor", (Object)this.closeConnectionIfIdleFor).add("defaultReadOnly", this.defaultReadOnly).add("connectionInitializationStatements", this.connectionInitializationStatements).toString();
    }
}

