/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.db;

import com.yammer.dropwizard.db.DatabaseConfiguration;
import com.yammer.dropwizard.db.ManagedDataSource;
import com.yammer.dropwizard.db.ManagedPooledDataSource;
import java.util.Map;
import java.util.Properties;
import org.apache.tomcat.dbcp.dbcp.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.DriverManagerConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.pool.ObjectPool;
import org.apache.tomcat.dbcp.pool.impl.GenericObjectPool;

public class ManagedDataSourceFactory {
    public ManagedDataSource build(DatabaseConfiguration configuration) throws ClassNotFoundException {
        Class.forName(configuration.getDriverClass());
        GenericObjectPool pool = this.buildPool(configuration);
        Properties properties = new Properties();
        for (Map.Entry property : configuration.getProperties().entrySet()) {
            properties.setProperty((String)property.getKey(), (String)property.getValue());
        }
        properties.setProperty("user", configuration.getUser());
        properties.setProperty("password", configuration.getPassword());
        DriverManagerConnectionFactory factory = new DriverManagerConnectionFactory(configuration.getUrl(), properties);
        PoolableConnectionFactory connectionFactory = new PoolableConnectionFactory((ConnectionFactory)factory, (ObjectPool)pool, null, configuration.getValidationQuery(), configuration.getConnectionInitializationStatements(), configuration.isDefaultReadOnly(), true);
        connectionFactory.setPool((ObjectPool)pool);
        return new ManagedPooledDataSource((ObjectPool)pool);
    }

    private GenericObjectPool buildPool(DatabaseConfiguration configuration) {
        GenericObjectPool pool = new GenericObjectPool(null);
        pool.setMaxWait(configuration.getMaxWaitForConnection().toMilliseconds());
        pool.setMinIdle(configuration.getMinSize());
        pool.setMaxActive(configuration.getMaxSize());
        pool.setMaxIdle(configuration.getMaxSize());
        pool.setTestWhileIdle(configuration.isCheckConnectionWhileIdle());
        pool.setTimeBetweenEvictionRunsMillis(configuration.getCheckConnectionHealthWhenIdleFor().toMilliseconds());
        pool.setMinEvictableIdleTimeMillis(configuration.getCloseConnectionIfIdleFor().toMilliseconds());
        pool.setWhenExhaustedAction((byte)1);
        return pool;
    }
}

