/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.hibernate;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.hibernate4.Hibernate4Module;
import com.google.common.collect.ImmutableList;
import com.yammer.dropwizard.ConfiguredBundle;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.db.ConfigurationStrategy;
import com.yammer.dropwizard.db.DatabaseConfiguration;
import com.yammer.dropwizard.hibernate.SessionFactoryFactory;
import com.yammer.dropwizard.hibernate.SessionFactoryHealthCheck;
import com.yammer.dropwizard.hibernate.UnitOfWorkResourceMethodDispatchAdapter;
import com.yammer.metrics.core.HealthCheck;
import java.util.List;
import org.hibernate.SessionFactory;

public abstract class HibernateBundle<T extends Configuration>
implements ConfiguredBundle<T>,
ConfigurationStrategy<T> {
    private SessionFactory sessionFactory;
    private final ImmutableList<Class<?>> entities;
    private final SessionFactoryFactory sessionFactoryFactory;

    protected HibernateBundle(Class<?> ... entities) {
        this(ImmutableList.copyOf((Object[])entities), new SessionFactoryFactory());
    }

    protected HibernateBundle(ImmutableList<Class<?>> entities, SessionFactoryFactory sessionFactoryFactory) {
        this.entities = entities;
        this.sessionFactoryFactory = sessionFactoryFactory;
    }

    public final void initialize(Bootstrap<?> bootstrap) {
        bootstrap.getObjectMapperFactory().registerModule((Module)new Hibernate4Module());
    }

    public final void run(T configuration, Environment environment) throws Exception {
        DatabaseConfiguration dbConfig = this.getDatabaseConfiguration((Configuration)configuration);
        this.sessionFactory = this.sessionFactoryFactory.build(environment, dbConfig, (List<Class<?>>)this.entities);
        environment.addProvider((Object)new UnitOfWorkResourceMethodDispatchAdapter(this.sessionFactory));
        environment.addHealthCheck((HealthCheck)new SessionFactoryHealthCheck("hibernate", this.sessionFactory, dbConfig.getValidationQuery()));
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

