/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.hibernate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.db.DatabaseConfiguration;
import com.yammer.dropwizard.db.ManagedDataSource;
import com.yammer.dropwizard.db.ManagedDataSourceFactory;
import com.yammer.dropwizard.hibernate.ManagedSessionFactory;
import com.yammer.dropwizard.lifecycle.Managed;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFactoryFactory.class);
    private final ManagedDataSourceFactory dataSourceFactory = new ManagedDataSourceFactory();

    public SessionFactory build(Environment environment, DatabaseConfiguration dbConfig, List<Class<?>> entities) throws ClassNotFoundException {
        ManagedDataSource dataSource = this.dataSourceFactory.build(dbConfig);
        ConnectionProvider provider = this.buildConnectionProvider((DataSource)dataSource, (ImmutableMap<String, String>)dbConfig.getProperties());
        SessionFactory factory = this.buildSessionFactory(dbConfig, provider, (ImmutableMap<String, String>)dbConfig.getProperties(), entities);
        ManagedSessionFactory managedFactory = new ManagedSessionFactory(factory, dataSource);
        environment.manage((Managed)managedFactory);
        return managedFactory;
    }

    private ConnectionProvider buildConnectionProvider(DataSource dataSource, ImmutableMap<String, String> properties) {
        DatasourceConnectionProviderImpl connectionProvider = new DatasourceConnectionProviderImpl();
        connectionProvider.setDataSource(dataSource);
        connectionProvider.configure(properties);
        return connectionProvider;
    }

    private SessionFactory buildSessionFactory(DatabaseConfiguration dbConfig, ConnectionProvider connectionProvider, ImmutableMap<String, String> properties, List<Class<?>> entities) {
        Configuration configuration = new Configuration();
        configuration.setProperty("hibernate.current_session_context_class", "managed");
        configuration.setProperty("hibernate.use_sql_comments", Boolean.toString(dbConfig.isAutoCommentsEnabled()));
        configuration.setProperty("hibernate.jdbc.use_get_generated_keys", "true");
        configuration.setProperty("hibernate.generate_statistics", "true");
        configuration.setProperty("hibernate.bytecode.use_reflection_optimizer", "true");
        configuration.setProperty("hibernate.order_updates", "true");
        configuration.setProperty("hibernate.order_inserts", "true");
        configuration.setProperty("hibernate.id.new_generator_mappings", "true");
        configuration.setProperty("jadira.usertype.autoRegisterUserTypes", "true");
        for (Map.Entry property : properties.entrySet()) {
            configuration.setProperty((String)property.getKey(), (String)property.getValue());
        }
        this.addAnnotatedClasses(configuration, entities);
        ServiceRegistry registry = new ServiceRegistryBuilder().addService(ConnectionProvider.class, (Service)connectionProvider).applySettings(properties).buildServiceRegistry();
        return configuration.buildSessionFactory(registry);
    }

    private void addAnnotatedClasses(Configuration configuration, Iterable<Class<?>> entities) {
        TreeSet entityClasses = Sets.newTreeSet();
        for (Class<?> klass : entities) {
            configuration.addAnnotatedClass(klass);
            entityClasses.add(klass.getCanonicalName());
        }
        LOGGER.info("Entity classes: {}", (Object)entityClasses);
    }
}

