/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.hibernate;

import com.yammer.metrics.core.HealthCheck;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class SessionFactoryHealthCheck
extends HealthCheck {
    private final SessionFactory sessionFactory;
    private final String validationQuery;

    public SessionFactoryHealthCheck(String name, SessionFactory sessionFactory, String validationQuery) {
        super(name);
        this.sessionFactory = sessionFactory;
        this.validationQuery = validationQuery;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HealthCheck.Result check() throws Exception {
        Session session = this.sessionFactory.openSession();
        try {
            Transaction txn = session.beginTransaction();
            try {
                session.createSQLQuery(this.validationQuery).list();
                txn.commit();
            }
            catch (Exception e) {
                if (txn.isActive()) {
                    txn.rollback();
                }
                throw e;
            }
        }
        finally {
            session.close();
        }
        return HealthCheck.Result.healthy();
    }
}

