/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.migrations;

import com.google.common.collect.Maps;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.db.ConfigurationStrategy;
import com.yammer.dropwizard.migrations.AbstractLiquibaseCommand;
import com.yammer.dropwizard.migrations.DbCalculateChecksumCommand;
import com.yammer.dropwizard.migrations.DbClearChecksumsCommand;
import com.yammer.dropwizard.migrations.DbDropAllCommand;
import com.yammer.dropwizard.migrations.DbDumpCommand;
import com.yammer.dropwizard.migrations.DbFastForwardCommand;
import com.yammer.dropwizard.migrations.DbGenerateDocsCommand;
import com.yammer.dropwizard.migrations.DbLocksCommand;
import com.yammer.dropwizard.migrations.DbMigrateCommand;
import com.yammer.dropwizard.migrations.DbPrepareRollbackCommand;
import com.yammer.dropwizard.migrations.DbRollbackCommand;
import com.yammer.dropwizard.migrations.DbStatusCommand;
import com.yammer.dropwizard.migrations.DbTagCommand;
import com.yammer.dropwizard.migrations.DbTestCommand;
import java.util.SortedMap;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    private static final String COMMAND_NAME_ATTR = "subcommand";
    private final SortedMap<String, AbstractLiquibaseCommand<T>> subcommands = Maps.newTreeMap();

    public DbCommand(ConfigurationStrategy<T> strategy, Class<T> configurationClass) {
        super("db", "Run database migration tasks", strategy, configurationClass);
        this.addSubcommand(new DbCalculateChecksumCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbClearChecksumsCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbDropAllCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbDumpCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbFastForwardCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbGenerateDocsCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbLocksCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbMigrateCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbPrepareRollbackCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbRollbackCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbStatusCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbTagCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbTestCommand<T>(strategy, configurationClass));
    }

    private void addSubcommand(AbstractLiquibaseCommand<T> subcommand) {
        this.subcommands.put(subcommand.getName(), subcommand);
    }

    public void configure(Subparser subparser) {
        for (AbstractLiquibaseCommand<T> subcommand : this.subcommands.values()) {
            Subparser cmdParser = subparser.addSubparsers().addParser(subcommand.getName()).setDefault(COMMAND_NAME_ATTR, (Object)subcommand.getName()).description(subcommand.getDescription());
            subcommand.configure(cmdParser);
        }
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        AbstractLiquibaseCommand subcommand = (AbstractLiquibaseCommand)((Object)this.subcommands.get(namespace.getString(COMMAND_NAME_ATTR)));
        subcommand.run(namespace, liquibase);
    }
}

