/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.migrations;

import com.google.common.base.Charsets;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.db.ConfigurationStrategy;
import com.yammer.dropwizard.migrations.AbstractLiquibaseCommand;
import java.io.PrintStream;
import liquibase.Liquibase;
import liquibase.diff.Diff;
import liquibase.diff.DiffResult;
import liquibase.diff.DiffStatusListener;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbDumpCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    public DbDumpCommand(ConfigurationStrategy<T> strategy, Class<T> configurationClass) {
        super("dump", "Generate a dump of the existing database state.", strategy, configurationClass);
    }

    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-o", "--output"}).dest("output").help("Write output to <file> instead of stdout");
        ArgumentGroup tables = subparser.addArgumentGroup("Tables");
        tables.addArgument(new String[]{"--tables"}).action((ArgumentAction)Arguments.storeTrue()).dest("tables").help("Check for added or removed tables (default)");
        tables.addArgument(new String[]{"--ignore-tables"}).action((ArgumentAction)Arguments.storeFalse()).dest("tables").help("Ignore tables");
        ArgumentGroup columns = subparser.addArgumentGroup("Columns");
        columns.addArgument(new String[]{"--columns"}).action((ArgumentAction)Arguments.storeTrue()).dest("columns").help("Check for added, removed, or modified tables (default)");
        columns.addArgument(new String[]{"--ignore-columns"}).action((ArgumentAction)Arguments.storeFalse()).dest("columns").help("Ignore columns");
        ArgumentGroup views = subparser.addArgumentGroup("Views");
        views.addArgument(new String[]{"--views"}).action((ArgumentAction)Arguments.storeTrue()).dest("views").help("Check for added, removed, or modified views (default)");
        views.addArgument(new String[]{"--ignore-views"}).action((ArgumentAction)Arguments.storeFalse()).dest("views").help("Ignore views");
        ArgumentGroup primaryKeys = subparser.addArgumentGroup("Primary Keys");
        primaryKeys.addArgument(new String[]{"--primary-keys"}).action((ArgumentAction)Arguments.storeTrue()).dest("primary-keys").help("Check for changed primary keys (default)");
        primaryKeys.addArgument(new String[]{"--ignore-primary-keys"}).action((ArgumentAction)Arguments.storeFalse()).dest("primary-keys").help("Ignore primary keys");
        ArgumentGroup uniqueConstraints = subparser.addArgumentGroup("Unique Constraints");
        uniqueConstraints.addArgument(new String[]{"--unique-constraints"}).action((ArgumentAction)Arguments.storeTrue()).dest("unique-constraints").help("Check for changed unique constraints (default)");
        uniqueConstraints.addArgument(new String[]{"--ignore-unique-constraints"}).action((ArgumentAction)Arguments.storeFalse()).dest("unique-constraints").help("Ignore unique constraints");
        ArgumentGroup indexes = subparser.addArgumentGroup("Indexes");
        indexes.addArgument(new String[]{"--indexes"}).action((ArgumentAction)Arguments.storeTrue()).dest("indexes").help("Check for changed indexes (default)");
        indexes.addArgument(new String[]{"--ignore-indexes"}).action((ArgumentAction)Arguments.storeFalse()).dest("indexes").help("Ignore indexes");
        ArgumentGroup foreignKeys = subparser.addArgumentGroup("Foreign Keys");
        foreignKeys.addArgument(new String[]{"--foreign-keys"}).action((ArgumentAction)Arguments.storeTrue()).dest("foreign-keys").help("Check for changed foreign keys (default)");
        foreignKeys.addArgument(new String[]{"--ignore-foreign-keys"}).action((ArgumentAction)Arguments.storeFalse()).dest("foreign-keys").help("Ignore foreign keys");
        ArgumentGroup sequences = subparser.addArgumentGroup("Sequences");
        sequences.addArgument(new String[]{"--sequences"}).action((ArgumentAction)Arguments.storeTrue()).dest("sequences").help("Check for changed sequences (default)");
        sequences.addArgument(new String[]{"--ignore-sequences"}).action((ArgumentAction)Arguments.storeFalse()).dest("sequences").help("Ignore foreign keys");
        ArgumentGroup data = subparser.addArgumentGroup("Data");
        data.addArgument(new String[]{"--data"}).action((ArgumentAction)Arguments.storeTrue()).dest("data").help("Check for changed data").setDefault((Object)Boolean.FALSE);
        data.addArgument(new String[]{"--ignore-data"}).action((ArgumentAction)Arguments.storeFalse()).dest("data").help("Ignore data (default)").setDefault((Object)Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        Diff diff = new Diff(liquibase.getDatabase(), (String)null);
        diff.addStatusListener(new DiffStatusListener(){

            public void statusUpdate(String message) {
                System.err.println(message);
            }
        });
        diff.setDiffColumns(namespace.getBoolean("columns").booleanValue());
        diff.setDiffData(namespace.getBoolean("data").booleanValue());
        diff.setDiffForeignKeys(namespace.getBoolean("foreign-keys").booleanValue());
        diff.setDiffIndexes(namespace.getBoolean("indexes").booleanValue());
        diff.setDiffPrimaryKeys(namespace.getBoolean("primary-keys").booleanValue());
        diff.setDiffSequences(namespace.getBoolean("sequences").booleanValue());
        diff.setDiffTables(namespace.getBoolean("tables").booleanValue());
        diff.setDiffUniqueConstraints(namespace.getBoolean("unique-constraints").booleanValue());
        diff.setDiffViews(namespace.getBoolean("views").booleanValue());
        DiffResult diffResult = diff.compare();
        String filename = namespace.getString("output");
        if (filename != null) {
            PrintStream file = new PrintStream(filename, Charsets.UTF_8.name());
            try {
                diffResult.printChangeLog(file, liquibase.getDatabase());
            }
            finally {
                file.close();
            }
        } else {
            diffResult.printChangeLog(System.out, liquibase.getDatabase());
        }
    }
}

