/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.migrations;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.db.ConfigurationStrategy;
import com.yammer.dropwizard.migrations.AbstractLiquibaseCommand;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbPrepareRollbackCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    public DbPrepareRollbackCommand(ConfigurationStrategy<T> strategy, Class<T> configurationClass) {
        super("prepare-rollback", "Generate rollback DDL scripts for pending change sets.", strategy, configurationClass);
    }

    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-c", "--count"}).dest("count").type(Integer.class).help("limit script to the specified number of pending change sets");
        subparser.addArgument(new String[]{"-i", "--include"}).action((ArgumentAction)Arguments.append()).dest("contexts").help("include change sets from the given context");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        String context = this.getContext(namespace);
        Integer count = namespace.getInt("count");
        if (count != null) {
            liquibase.futureRollbackSQL(count, context, (Writer)new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8));
        } else {
            liquibase.futureRollbackSQL(context, (Writer)new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8));
        }
    }

    private String getContext(Namespace namespace) {
        List contexts = namespace.getList("contexts");
        if (contexts == null) {
            return "";
        }
        return Joiner.on((char)',').join((Iterable)contexts);
    }
}

