/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.migrations;

import com.google.common.base.Joiner;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.db.ConfigurationStrategy;
import com.yammer.dropwizard.migrations.AbstractLiquibaseCommand;
import java.util.List;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbTestCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    public DbTestCommand(ConfigurationStrategy<T> strategy, Class<T> configurationClass) {
        super("test", "Apply and rollback pending change sets.", strategy, configurationClass);
    }

    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-i", "--include"}).action((ArgumentAction)Arguments.append()).dest("contexts").help("include change sets from the given context");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        liquibase.updateTestingRollback(this.getContext(namespace));
    }

    private String getContext(Namespace namespace) {
        List contexts = namespace.getList("contexts");
        if (contexts == null) {
            return "";
        }
        return Joiner.on((char)',').join((Iterable)contexts);
    }
}

