/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.migrations;

import com.yammer.dropwizard.db.DatabaseConfiguration;
import com.yammer.dropwizard.db.ManagedDataSource;
import com.yammer.dropwizard.db.ManagedDataSourceFactory;
import com.yammer.dropwizard.lifecycle.Managed;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class ManagedLiquibase
extends Liquibase
implements Managed {
    public ManagedLiquibase(DatabaseConfiguration configuration) throws LiquibaseException, ClassNotFoundException, SQLException {
        super("migrations.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), (DatabaseConnection)new ManagedJdbcConnection(new ManagedDataSourceFactory().build(configuration)));
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        DatabaseConnection connection = this.getDatabase().getConnection();
        if (connection instanceof ManagedJdbcConnection) {
            ((ManagedJdbcConnection)connection).stop();
        }
    }

    private static class ManagedJdbcConnection
    extends JdbcConnection
    implements Managed {
        private final ManagedDataSource dataSource;

        private ManagedJdbcConnection(ManagedDataSource dataSource) throws SQLException {
            super(dataSource.getConnection());
            this.dataSource = dataSource;
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
            this.dataSource.stop();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

