/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.testing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yammer.dropwizard.json.ObjectMapperFactory;
import com.yammer.dropwizard.testing.FixtureHelpers;
import java.io.IOException;

public class JsonHelpers {
    private static final ObjectMapper MAPPER = new ObjectMapperFactory().build();

    private JsonHelpers() {
    }

    public static String asJson(Object object) throws IOException {
        return MAPPER.writeValueAsString(object);
    }

    public static <T> T fromJson(String json, Class<T> klass) throws IOException {
        return (T)MAPPER.readValue(json, klass);
    }

    public static <T> T fromJson(String json, TypeReference<T> reference) throws IOException {
        return (T)MAPPER.readValue(json, reference);
    }

    public static String jsonFixture(String filename) throws IOException {
        return MAPPER.writeValueAsString(MAPPER.readValue(FixtureHelpers.fixture(filename), JsonNode.class));
    }
}

