/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.LowLevelAppDescriptor;
import com.yammer.dropwizard.jersey.DropwizardResourceConfig;
import com.yammer.dropwizard.jersey.JacksonMessageBodyProvider;
import com.yammer.dropwizard.json.ObjectMapperFactory;
import com.yammer.dropwizard.validation.Validator;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class ResourceTest {
    private final Set<Object> singletons = Sets.newHashSet();
    private final Set<Class<?>> providers = Sets.newHashSet();
    private final ObjectMapperFactory objectMapperFactory = new ObjectMapperFactory();
    private final Map<String, Boolean> features = Maps.newHashMap();
    private final Map<String, Object> properties = Maps.newHashMap();
    private JerseyTest test;
    private Validator validator = new Validator();

    protected abstract void setUpResources() throws Exception;

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    protected void addResource(Object resource) {
        this.singletons.add(resource);
    }

    public void addProvider(Class<?> klass) {
        this.providers.add(klass);
    }

    public void addProvider(Object provider) {
        this.singletons.add(provider);
    }

    protected ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    protected void addFeature(String feature, Boolean value) {
        this.features.put(feature, value);
    }

    protected void addProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    protected Client client() {
        return this.test.client();
    }

    protected JerseyTest getJerseyTest() {
        return this.test;
    }

    @Before
    public final void setUpJersey() throws Exception {
        this.setUpResources();
        this.test = new JerseyTest(){

            protected AppDescriptor configure() {
                DropwizardResourceConfig config = new DropwizardResourceConfig(true);
                for (Class clazz : ResourceTest.this.providers) {
                    config.getClasses().add(clazz);
                }
                for (Map.Entry entry : ResourceTest.this.features.entrySet()) {
                    config.getFeatures().put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : ResourceTest.this.properties.entrySet()) {
                    config.getProperties().put(entry.getKey(), entry.getValue());
                }
                ObjectMapper mapper = ResourceTest.this.getObjectMapperFactory().build();
                config.getSingletons().add(new JacksonMessageBodyProvider(mapper, ResourceTest.this.validator));
                config.getSingletons().addAll(ResourceTest.this.singletons);
                return new LowLevelAppDescriptor.Builder((ResourceConfig)config).build();
            }
        };
        this.test.setUp();
    }

    @After
    public final void tearDownJersey() throws Exception {
        if (this.test != null) {
            this.test.tearDown();
        }
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

