/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.testing.junit;

import com.google.common.collect.ImmutableMap;
import com.yammer.dropwizard.Service;
import com.yammer.dropwizard.cli.ServerCommand;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.lifecycle.ServerLifecycleListener;
import java.util.Map;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.server.Server;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DropwizardServiceRule<C extends Configuration>
implements TestRule {
    private final Class<? extends Service<C>> serviceClass;
    private final String configPath;
    private C configuration;
    private Service<C> service;
    private Environment environment;
    private Server jettyServer;

    public DropwizardServiceRule(Class<? extends Service<C>> serviceClass, String configPath) {
        this.serviceClass = serviceClass;
        this.configPath = configPath;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                DropwizardServiceRule.this.startIfRequired();
                try {
                    base.evaluate();
                }
                finally {
                    DropwizardServiceRule.this.jettyServer.stop();
                }
            }
        };
    }

    private void startIfRequired() {
        if (this.jettyServer != null) {
            return;
        }
        try {
            this.service = this.serviceClass.newInstance();
            Bootstrap bootstrap = new Bootstrap<C>(this.service){

                public void runWithBundles(C configuration, Environment environment) throws Exception {
                    environment.addServerLifecycleListener(new ServerLifecycleListener(){

                        public void serverStarted(Server server) {
                            DropwizardServiceRule.this.jettyServer = server;
                        }
                    });
                    DropwizardServiceRule.this.configuration = configuration;
                    DropwizardServiceRule.this.environment = environment;
                    super.runWithBundles(configuration, environment);
                }
            };
            this.service.initialize(bootstrap);
            ServerCommand command = new ServerCommand(this.service);
            Namespace namespace = new Namespace((Map)ImmutableMap.of((Object)"file", (Object)this.configPath));
            command.run(bootstrap, namespace);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public int getLocalPort() {
        return this.jettyServer.getConnectors()[0].getLocalPort();
    }

    public <S extends Service<C>> S getService() {
        return (S)this.service;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

