/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.views;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import org.codehaus.jackson.annotate.JsonIgnore;

public abstract class View {
    private final String templateName;
    private final Timer renderingTimer;

    protected View(String templateName) {
        this.templateName = this.resolveName(templateName);
        this.renderingTimer = Metrics.newTimer(this.getClass(), (String)"rendering");
    }

    private String resolveName(String templateName) {
        if (templateName.startsWith("/")) {
            return templateName;
        }
        String packagePath = this.getClass().getPackage().getName().replace('.', '/');
        return String.format("/%s/%s", packagePath, templateName);
    }

    @JsonIgnore
    public String getTemplateName() {
        return this.templateName;
    }

    @JsonIgnore
    Timer getRenderingTimer() {
        return this.renderingTimer;
    }
}

