/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.views;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.sun.jersey.spi.service.ServiceFinder;
import com.yammer.dropwizard.views.View;
import com.yammer.dropwizard.views.ViewRenderException;
import com.yammer.dropwizard.views.ViewRenderer;
import com.yammer.metrics.core.TimerContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"text/html", "application/xhtml+xml"})
public class ViewMessageBodyWriter
implements MessageBodyWriter<View> {
    private static final String MISSING_TEMPLATE_MSG = "<html><head><title>Missing Template</title></head><body><h1>Missing Template</h1><p>{0}</p></body></html>";
    @Context
    private HttpHeaders headers;
    private final ImmutableList<ViewRenderer> renderers;

    public ViewMessageBodyWriter() {
        this(null);
    }

    @VisibleForTesting
    public ViewMessageBodyWriter(HttpHeaders headers) {
        this.headers = headers;
        this.renderers = ImmutableList.copyOf((Iterable)ServiceFinder.find(ViewRenderer.class));
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return View.class.isAssignableFrom(type);
    }

    public long getSize(View t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(View t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        TimerContext context = t.getRenderingTimer().time();
        try {
            Iterator i$ = this.renderers.iterator();
            while (i$.hasNext()) {
                ViewRenderer renderer = (ViewRenderer)i$.next();
                if (renderer.isRenderable(t)) {
                    renderer.render(t, this.detectLocale(this.headers), entityStream);
                    return;
                }
            }
            throw new ViewRenderException("Unable to find a renderer for " + t.getTemplateName());
        }
        catch (FileNotFoundException e) {
            String msg = MessageFormat.format(MISSING_TEMPLATE_MSG, e.getMessage());
            throw new WebApplicationException(Response.serverError().type(MediaType.TEXT_HTML_TYPE).entity((Object)msg).build());
        }
        finally {
            context.stop();
        }
    }

    private Locale detectLocale(HttpHeaders headers) {
        List languages = headers.getAcceptableLanguages();
        for (Locale locale : languages) {
            if (locale.toString().contains("*")) continue;
            return locale;
        }
        return Locale.getDefault();
    }
}

