/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.views.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yammer.dropwizard.views.View;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class CachingMustacheFactory
extends DefaultMustacheFactory {
    private final Class<? extends View> klass;
    private final LoadingCache<String, Mustache> mustaches;

    CachingMustacheFactory(Class<? extends View> klass) {
        this.klass = klass;
        this.mustaches = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Mustache>(){

            public Mustache load(String key) throws Exception {
                return CachingMustacheFactory.this.originalCompile(key);
            }
        });
    }

    public Reader getReader(String resourceName) {
        InputStream is = this.klass.getResourceAsStream(resourceName);
        if (is == null) {
            throw new MustacheException("Template " + resourceName + " not found");
        }
        return new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
    }

    public Mustache compile(String name) {
        return (Mustache)this.mustaches.getUnchecked((Object)name);
    }

    private Mustache originalCompile(String name) {
        return super.compile(name);
    }
}

