/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.views.mustache;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yammer.dropwizard.views.View;
import com.yammer.dropwizard.views.ViewRenderer;
import com.yammer.dropwizard.views.mustache.CachingMustacheFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import javax.ws.rs.WebApplicationException;

public class MustacheViewRenderer
implements ViewRenderer {
    private final LoadingCache<Class<? extends View>, MustacheFactory> factories = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class<? extends View>, MustacheFactory>(){

        public MustacheFactory load(Class<? extends View> key) throws Exception {
            return new CachingMustacheFactory(key);
        }
    });

    @Override
    public boolean isRenderable(View view) {
        return view.getTemplateName().endsWith(".mustache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(View view, Locale locale, OutputStream output) throws IOException, WebApplicationException {
        OutputStreamWriter writer = new OutputStreamWriter(output, Charsets.UTF_8);
        try {
            Mustache template = ((MustacheFactory)this.factories.getUnchecked(view.getClass())).compile(view.getTemplateName());
            template.execute((Writer)writer, (Object)view);
        }
        finally {
            writer.close();
        }
    }
}

