package com.yammer.metrics;

import java.util.concurrent.atomic.AtomicLong;

/**
 * An incrementing and decrementing counter metric.
 */
public class Counter implements Metric {
    private final AtomicLong count;

    public Counter() {
        this.count = new AtomicLong(0);
    }

    /**
     * Increment the counter by one.
     */
    public void inc() {
        inc(1);
    }

    /**
     * Increment the counter by {@code n}.
     *
     * @param n the amount by which the counter will be increased
     */
    public void inc(long n) {
        count.addAndGet(n);
    }

    /**
     * Decrement the counter by one.
     */
    public void dec() {
        dec(1);
    }

    /**
     * Decrement the counter by {@code n}.
     *
     * @param n the amount by which the counter will be increased
     */
    public void dec(long n) {
        count.addAndGet(0 - n);
    }

    /**
     * Returns the counter's current value.
     *
     * @return the counter's current value
     */
    public long getCount() {
        return count.get();
    }
}
