/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.httpclient;

import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultRequestDirector;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;

class InstrumentedRequestDirector
extends DefaultRequestDirector {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String HEAD = "HEAD";
    private static final String PUT = "PUT";
    private static final String OPTIONS = "OPTIONS";
    private static final String DELETE = "DELETE";
    private static final String TRACE = "TRACE";
    private static final String CONNECT = "CONNECT";
    private static final String MOVE = "MOVE";
    private static final String PATCH = "PATCH";
    private final Timer getTimer;
    private final Timer postTimer;
    private final Timer headTimer;
    private final Timer putTimer;
    private final Timer deleteTimer;
    private final Timer optionsTimer;
    private final Timer traceTimer;
    private final Timer connectTimer;
    private final Timer moveTimer;
    private final Timer patchTimer;
    private final Timer otherTimer;

    InstrumentedRequestDirector(MetricsRegistry registry, Log log, HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler, HttpParams params) {
        super(log, requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectStrategy, targetAuthStrategy, proxyAuthStrategy, userTokenHandler, params);
        this.getTimer = registry.newTimer(HttpClient.class, "get-requests");
        this.postTimer = registry.newTimer(HttpClient.class, "post-requests");
        this.headTimer = registry.newTimer(HttpClient.class, "head-requests");
        this.putTimer = registry.newTimer(HttpClient.class, "put-requests");
        this.deleteTimer = registry.newTimer(HttpClient.class, "delete-requests");
        this.optionsTimer = registry.newTimer(HttpClient.class, "options-requests");
        this.traceTimer = registry.newTimer(HttpClient.class, "trace-requests");
        this.connectTimer = registry.newTimer(HttpClient.class, "connect-requests");
        this.moveTimer = registry.newTimer(HttpClient.class, "move-requests");
        this.patchTimer = registry.newTimer(HttpClient.class, "patch-requests");
        this.otherTimer = registry.newTimer(HttpClient.class, "other-requests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException, IOException {
        TimerContext timerContext = this.timer(request).time();
        try {
            HttpResponse httpResponse = super.execute(target, request, context);
            return httpResponse;
        }
        finally {
            timerContext.stop();
        }
    }

    private Timer timer(HttpRequest request) {
        String method = request.getRequestLine().getMethod();
        if (GET.equalsIgnoreCase(method)) {
            return this.getTimer;
        }
        if (POST.equalsIgnoreCase(method)) {
            return this.postTimer;
        }
        if (PUT.equalsIgnoreCase(method)) {
            return this.putTimer;
        }
        if (HEAD.equalsIgnoreCase(method)) {
            return this.headTimer;
        }
        if (DELETE.equalsIgnoreCase(method)) {
            return this.deleteTimer;
        }
        if (OPTIONS.equalsIgnoreCase(method)) {
            return this.optionsTimer;
        }
        if (TRACE.equalsIgnoreCase(method)) {
            return this.traceTimer;
        }
        if (CONNECT.equalsIgnoreCase(method)) {
            return this.connectTimer;
        }
        if (PATCH.equalsIgnoreCase(method)) {
            return this.patchTimer;
        }
        if (MOVE.equalsIgnoreCase(method)) {
            return this.moveTimer;
        }
        return this.otherTimer;
    }
}

