/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.jvm;

import com.yammer.metrics.Gauge;
import com.yammer.metrics.Metric;
import com.yammer.metrics.MetricRegistry;
import com.yammer.metrics.MetricSet;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GarbageCollectorMetricSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final List<GarbageCollectorMXBean> garbageCollectors;

    public GarbageCollectorMetricSet() {
        this(ManagementFactory.getGarbageCollectorMXBeans());
    }

    public GarbageCollectorMetricSet(Collection<GarbageCollectorMXBean> garbageCollectors) {
        this.garbageCollectors = new ArrayList<GarbageCollectorMXBean>(garbageCollectors);
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Object> gauges = new HashMap<String, Object>();
        for (final GarbageCollectorMXBean gc : this.garbageCollectors) {
            String name = WHITESPACE.matcher(gc.getName()).replaceAll("-");
            gauges.put(MetricRegistry.name((String)name, (String[])new String[]{"count"}), new Gauge<Long>(){

                public Long getValue() {
                    return gc.getCollectionCount();
                }
            });
            gauges.put(MetricRegistry.name((String)name, (String[])new String[]{"time"}), new Gauge<Long>(){

                public Long getValue() {
                    return gc.getCollectionTime();
                }
            });
        }
        return Collections.unmodifiableMap(gauges);
    }
}

