/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.servlets;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.yammer.metrics.MetricRegistry;
import com.yammer.metrics.json.MetricsModule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetricsServlet
extends HttpServlet {
    public static final String RATE_UNIT = MetricsServlet.class.getCanonicalName() + ".rateUnit";
    public static final String DURATION_UNIT = MetricsServlet.class.getCanonicalName() + ".durationUnit";
    public static final String SHOW_SAMPLES = MetricsServlet.class.getCanonicalName() + ".showSamples";
    public static final String METRICS_REGISTRY = MetricsServlet.class.getCanonicalName() + ".registry";
    private static final long serialVersionUID = 1049773947734939602L;
    private static final String CONTENT_TYPE = "application/json";
    private transient MetricRegistry registry;
    private transient ObjectMapper mapper;

    public void init(ServletConfig config) throws ServletException {
        Object registryAttr = config.getServletContext().getAttribute(METRICS_REGISTRY);
        if (!(registryAttr instanceof MetricRegistry)) {
            throw new ServletException("Couldn't find a MetricRegistry instance.");
        }
        this.registry = (MetricRegistry)registryAttr;
        TimeUnit rateUnit = this.parseTimeUnit(config.getServletContext().getInitParameter(RATE_UNIT), TimeUnit.SECONDS);
        TimeUnit durationUnit = this.parseTimeUnit(config.getServletContext().getInitParameter(DURATION_UNIT), TimeUnit.SECONDS);
        boolean showSamples = Boolean.parseBoolean(config.getServletContext().getInitParameter(SHOW_SAMPLES));
        this.mapper = new ObjectMapper().registerModule((Module)new MetricsModule(rateUnit, durationUnit, showSamples));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        resp.setStatus(200);
        ServletOutputStream output = resp.getOutputStream();
        try {
            this.getWriter(req).writeValue((OutputStream)output, (Object)this.registry);
        }
        finally {
            output.close();
        }
    }

    private ObjectWriter getWriter(HttpServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return this.mapper.writerWithDefaultPrettyPrinter();
        }
        return this.mapper.writer();
    }

    private TimeUnit parseTimeUnit(String value, TimeUnit defaultValue) {
        try {
            return TimeUnit.valueOf(String.valueOf(value).toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

