/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f;

import com.google.common.base.Optional;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.crypto.RandomChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateResponse;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.StartedAuthentication;
import com.yubico.u2f.data.messages.StartedRegistration;
import com.yubico.u2f.data.messages.key.RawAuthenticateResponse;
import com.yubico.u2f.data.messages.key.RawRegisterResponse;
import com.yubico.u2f.exceptions.U2fException;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class U2F {
    public static final String U2F_VERSION = "U2F_V2";
    private static final ChallengeGenerator challengeGenerator = new RandomChallengeGenerator();
    public static final Crypto crypto = new BouncyCastleCrypto();
    public static final String AUTHENTICATE_TYP = "navigator.id.getAssertion";
    public static final String REGISTER_TYPE = "navigator.id.finishEnrollment";

    public static StartedRegistration startRegistration(String appId) {
        byte[] challenge = challengeGenerator.generateChallenge();
        String challengeBase64 = Base64.encodeBase64URLSafeString((byte[])challenge);
        return new StartedRegistration(challengeBase64, appId);
    }

    public static DeviceRegistration finishRegistration(StartedRegistration startedRegistration, RegisterResponse tokenResponse) throws U2fException {
        return U2F.finishRegistration(startedRegistration, tokenResponse, null);
    }

    public static DeviceRegistration finishRegistration(StartedRegistration startedRegistration, RegisterResponse tokenResponse, Set<String> facets) throws U2fException {
        ClientData clientData = tokenResponse.getClientData();
        clientData.checkContent(REGISTER_TYPE, startedRegistration.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
        RawRegisterResponse rawRegisterResponse = RawRegisterResponse.fromBase64(tokenResponse.getRegistrationData());
        rawRegisterResponse.checkSignature(startedRegistration.getAppId(), clientData.getRawClientData());
        return rawRegisterResponse.createDevice();
    }

    public static StartedAuthentication startAuthentication(String appId, DeviceRegistration deviceRegistration) {
        byte[] challenge = challengeGenerator.generateChallenge();
        return new StartedAuthentication(Base64.encodeBase64URLSafeString((byte[])challenge), appId, Base64.encodeBase64URLSafeString((byte[])deviceRegistration.getKeyHandle()));
    }

    public static void finishAuthentication(StartedAuthentication startedAuthentication, AuthenticateResponse response, DeviceRegistration deviceRegistration) throws U2fException {
        U2F.finishAuthentication(startedAuthentication, response, deviceRegistration, null);
    }

    public static void finishAuthentication(StartedAuthentication startedAuthentication, AuthenticateResponse response, DeviceRegistration deviceRegistration, Set<String> facets) throws U2fException {
        ClientData clientData = response.getClientData();
        clientData.checkContent(AUTHENTICATE_TYP, startedAuthentication.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
        RawAuthenticateResponse rawAuthenticateResponse = RawAuthenticateResponse.fromBase64(response.getSignatureData());
        rawAuthenticateResponse.checkSignature(startedAuthentication.getAppId(), clientData.getRawClientData(), deviceRegistration.getPublicKey());
        rawAuthenticateResponse.checkUserPresence();
        deviceRegistration.checkAndIncrementCounter(rawAuthenticateResponse.getCounter());
    }
}

