/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data;

import com.google.common.base.Objects;
import com.yubico.u2f.data.DataObject;
import com.yubico.u2f.data.messages.key.util.ByteInputStream;
import com.yubico.u2f.exceptions.U2fException;
import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class DeviceRegistration
extends DataObject
implements Serializable {
    private static final long serialVersionUID = -142942195464329902L;
    public static final int INITIAL_COUNTER_VALUE = 0;
    private final byte[] keyHandle;
    private final byte[] publicKey;
    private final byte[] attestationCert;
    private int counter;

    public DeviceRegistration(byte[] keyHandle, byte[] publicKey, X509Certificate attestationCert, int counter) throws U2fException {
        this.keyHandle = keyHandle;
        this.publicKey = publicKey;
        try {
            this.attestationCert = attestationCert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new U2fException("Invalid attestation certificate", e);
        }
        this.counter = counter;
    }

    public byte[] getKeyHandle() {
        return this.keyHandle;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate getAttestationCertificate() throws CertificateException, NoSuchFieldException {
        if (this.attestationCert == null) {
            throw new NoSuchFieldException();
        }
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteInputStream(this.attestationCert));
    }

    public int getCounter() {
        return this.counter;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyHandle, this.publicKey, this.attestationCert});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeviceRegistration)) {
            return false;
        }
        DeviceRegistration that = (DeviceRegistration)obj;
        return Arrays.equals(this.keyHandle, that.keyHandle) && Arrays.equals(this.publicKey, that.publicKey) && Arrays.equals(this.attestationCert, that.attestationCert);
    }

    public String toString() {
        return super.toJson();
    }

    public static DeviceRegistration fromJson(String json) {
        return (DeviceRegistration)GSON.fromJson(json, DeviceRegistration.class);
    }

    @Override
    public String toJson() {
        return GSON.toJson((Object)new DeviceWithoutCertificate(this.keyHandle, this.publicKey, this.counter));
    }

    public String toJsonWithAttestationCert() {
        return super.toJson();
    }

    public void checkAndIncrementCounter(int clientCounter) throws U2fException {
        if (clientCounter <= this.counter++) {
            throw new U2fException("Counter value smaller than expected!");
        }
    }

    private static class DeviceWithoutCertificate {
        private final byte[] keyHandle;
        private final byte[] publicKey;
        private final int counter;

        private DeviceWithoutCertificate(byte[] keyHandle, byte[] publicKey, int counter) {
            this.keyHandle = keyHandle;
            this.publicKey = publicKey;
            this.counter = counter;
        }
    }
}

