/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.yubico.u2f.data.DataObject;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.exceptions.U2fException;

public class AuthenticateResponse
extends DataObject {
    private final String clientData;
    private final String signatureData;
    private final String keyHandle;

    public AuthenticateResponse(String clientData, String signatureData, String keyHandle) {
        this.clientData = (String)Preconditions.checkNotNull((Object)clientData);
        this.signatureData = (String)Preconditions.checkNotNull((Object)signatureData);
        this.keyHandle = (String)Preconditions.checkNotNull((Object)keyHandle);
    }

    public ClientData getClientData() throws U2fException {
        return new ClientData(this.clientData);
    }

    public String getSignatureData() {
        return this.signatureData;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientData, this.signatureData, this.keyHandle});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticateResponse other = (AuthenticateResponse)obj;
        if (this.clientData == null ? other.clientData != null : !this.clientData.equals(other.clientData)) {
            return false;
        }
        if (this.keyHandle == null ? other.keyHandle != null : !this.keyHandle.equals(other.keyHandle)) {
            return false;
        }
        return !(this.signatureData == null ? other.signatureData != null : !this.signatureData.equals(other.signatureData));
    }

    public static AuthenticateResponse fromJson(String json) {
        Gson gson = new Gson();
        return (AuthenticateResponse)gson.fromJson(json, AuthenticateResponse.class);
    }
}

