/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.yubico.u2f.exceptions.InvalidFacetException;
import com.yubico.u2f.exceptions.U2fException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class ClientData {
    private static final String TYPE_PARAM = "typ";
    private static final String CHALLENGE_PARAM = "challenge";
    private static final String ORIGIN_PARAM = "origin";
    private final String type;
    private final String challenge;
    private final String origin;
    private final byte[] rawClientData;

    public byte[] getRawClientData() {
        return this.rawClientData;
    }

    public ClientData(String clientData) throws U2fException {
        this.rawClientData = Base64.decodeBase64((String)clientData);
        JsonElement clientDataAsElement = new JsonParser().parse(new String(this.rawClientData));
        if (!clientDataAsElement.isJsonObject()) {
            throw new U2fException("ClientData has wrong format");
        }
        JsonObject jsonObject = clientDataAsElement.getAsJsonObject();
        if (!jsonObject.has(TYPE_PARAM)) {
            throw new U2fException("Bad clientData: missing 'typ' param");
        }
        this.type = jsonObject.get(TYPE_PARAM).getAsString();
        if (!jsonObject.has(CHALLENGE_PARAM)) {
            throw new U2fException("Bad clientData: missing 'challenge' param");
        }
        this.challenge = jsonObject.get(CHALLENGE_PARAM).getAsString();
        this.origin = (String)Preconditions.checkNotNull((Object)jsonObject.get(ORIGIN_PARAM).getAsString());
    }

    public String toString() {
        return new String(this.rawClientData);
    }

    public String getChallenge() {
        return this.challenge;
    }

    public void checkContent(String type, String challenge, Optional<Set<String>> facets) throws U2fException {
        if (!type.equals(this.type)) {
            throw new U2fException("Bad clientData: bad type " + this.type);
        }
        if (!challenge.equals(this.challenge)) {
            throw new U2fException("Wrong challenge signed in clientData");
        }
        if (facets.isPresent()) {
            ClientData.verifyOrigin(this.origin, ClientData.canonicalizeOrigins((Set)facets.get()));
        }
    }

    private static void verifyOrigin(String origin, Set<String> allowedOrigins) throws InvalidFacetException {
        if (!allowedOrigins.contains(ClientData.canonicalizeOrigin(origin))) {
            throw new InvalidFacetException(origin + " is not a recognized home origin for this backend");
        }
    }

    public static Set<String> canonicalizeOrigins(Set<String> origins) throws InvalidFacetException {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String origin : origins) {
            result.add((Object)ClientData.canonicalizeOrigin(origin));
        }
        return result.build();
    }

    public static String canonicalizeOrigin(String url) throws InvalidFacetException {
        try {
            URI uri = new URI(url);
            return uri.getScheme() + "://" + uri.getAuthority();
        }
        catch (URISyntaxException e) {
            throw new InvalidFacetException("specified bad origin", e);
        }
    }
}

