/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.yubico.u2f.data.DataObject;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.exceptions.U2fException;

public class RegisterResponse
extends DataObject {
    private final String registrationData;
    private final String clientData;

    public RegisterResponse(String registrationData, String clientData) {
        this.registrationData = (String)Preconditions.checkNotNull((Object)registrationData);
        this.clientData = (String)Preconditions.checkNotNull((Object)clientData);
    }

    public String getRegistrationData() {
        return this.registrationData;
    }

    public ClientData getClientData() throws U2fException {
        return new ClientData(this.clientData);
    }

    public static RegisterResponse fromJson(String json) {
        return (RegisterResponse)GSON.fromJson(json, RegisterResponse.class);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.registrationData, this.clientData});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegisterResponse other = (RegisterResponse)obj;
        if (this.clientData == null ? other.clientData != null : !this.clientData.equals(other.clientData)) {
            return false;
        }
        return !(this.registrationData == null ? other.registrationData != null : !this.registrationData.equals(other.registrationData));
    }
}

