/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.yubico.u2f.data.DataObject;

public class StartedAuthentication
extends DataObject {
    private final String version;
    private final String challenge;
    private final String appId;
    private final String keyHandle;

    public StartedAuthentication(String challenge, String appId, String keyHandle) {
        this.version = "U2F_V2";
        this.challenge = (String)Preconditions.checkNotNull((Object)challenge);
        this.appId = (String)Preconditions.checkNotNull((Object)appId);
        this.keyHandle = (String)Preconditions.checkNotNull((Object)keyHandle);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version, this.challenge, this.appId, this.keyHandle});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StartedAuthentication other = (StartedAuthentication)obj;
        if (this.appId == null ? other.appId != null : !this.appId.equals(other.appId)) {
            return false;
        }
        if (this.challenge == null ? other.challenge != null : !this.challenge.equals(other.challenge)) {
            return false;
        }
        if (this.keyHandle == null ? other.keyHandle != null : !this.keyHandle.equals(other.keyHandle)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getAppId() {
        return this.appId;
    }

    public static StartedAuthentication fromJson(String json) {
        return (StartedAuthentication)GSON.fromJson(json, StartedAuthentication.class);
    }
}

