/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f;

import com.google.common.base.Optional;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.crypto.RandomChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateResponse;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.StartedAuthentication;
import com.yubico.u2f.data.messages.StartedRegistration;
import com.yubico.u2f.data.messages.key.RawAuthenticateResponse;
import com.yubico.u2f.data.messages.key.RawRegisterResponse;
import com.yubico.u2f.exceptions.U2fException;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class U2F {
    public static final String AUTHENTICATE_TYP = "navigator.id.getAssertion";
    public static final String REGISTER_TYPE = "navigator.id.finishEnrollment";
    public static final String U2F_VERSION = "U2F_V2";
    private final Crypto crypto;
    private final ChallengeGenerator challengeGenerator;

    public U2F(Crypto crypto, ChallengeGenerator challengeGenerator) {
        this.crypto = crypto;
        this.challengeGenerator = challengeGenerator;
    }

    public U2F() {
        this(new BouncyCastleCrypto(), new RandomChallengeGenerator());
    }

    public StartedRegistration startRegistration(String appId) {
        byte[] challenge = this.challengeGenerator.generateChallenge();
        String challengeBase64 = Base64.encodeBase64URLSafeString((byte[])challenge);
        return new StartedRegistration(challengeBase64, appId);
    }

    public DeviceRegistration finishRegistration(StartedRegistration startedRegistration, RegisterResponse response) throws U2fException {
        return this.finishRegistration(startedRegistration, response, null);
    }

    public DeviceRegistration finishRegistration(StartedRegistration startedRegistration, RegisterResponse response, Set<String> facets) throws U2fException {
        ClientData clientData = response.getClientData();
        clientData.checkContent(REGISTER_TYPE, startedRegistration.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
        RawRegisterResponse rawRegisterResponse = RawRegisterResponse.fromBase64(response.getRegistrationData(), this.crypto);
        rawRegisterResponse.checkSignature(startedRegistration.getAppId(), clientData.asJson());
        return rawRegisterResponse.createDevice();
    }

    public StartedAuthentication startAuthentication(String appId, DeviceRegistration deviceRegistration) {
        byte[] challenge = this.challengeGenerator.generateChallenge();
        return new StartedAuthentication(Base64.encodeBase64URLSafeString((byte[])challenge), appId, Base64.encodeBase64URLSafeString((byte[])deviceRegistration.getKeyHandle()));
    }

    public void finishAuthentication(StartedAuthentication startedAuthentication, AuthenticateResponse response, DeviceRegistration deviceRegistration) throws U2fException {
        this.finishAuthentication(startedAuthentication, response, deviceRegistration, null);
    }

    public void finishAuthentication(StartedAuthentication startedAuthentication, AuthenticateResponse response, DeviceRegistration deviceRegistration, Set<String> facets) throws U2fException {
        ClientData clientData = response.getClientData();
        clientData.checkContent(AUTHENTICATE_TYP, startedAuthentication.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
        RawAuthenticateResponse rawAuthenticateResponse = RawAuthenticateResponse.fromBase64(response.getSignatureData(), this.crypto);
        rawAuthenticateResponse.checkSignature(startedAuthentication.getAppId(), clientData.asJson(), deviceRegistration.getPublicKey());
        rawAuthenticateResponse.checkUserPresence();
        deviceRegistration.checkAndIncrementCounter(rawAuthenticateResponse.getCounter());
    }
}

