/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.json.JsonObject;
import com.yubico.u2f.exceptions.U2fException;

public class AuthenticateResponse
extends JsonObject {
    private static final int MAX_SIZE = 20000;
    private final String clientData;
    private final String signatureData;
    private final String keyHandle;

    public AuthenticateResponse(String clientData, String signatureData, String keyHandle) {
        this.clientData = (String)Preconditions.checkNotNull((Object)clientData);
        this.signatureData = (String)Preconditions.checkNotNull((Object)signatureData);
        this.keyHandle = (String)Preconditions.checkNotNull((Object)keyHandle);
    }

    public ClientData getClientData() throws U2fException {
        return new ClientData(this.clientData);
    }

    public String getSignatureData() {
        return this.signatureData;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientData, this.signatureData, this.keyHandle});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuthenticateResponse)) {
            return false;
        }
        AuthenticateResponse other = (AuthenticateResponse)obj;
        return Objects.equal((Object)this.clientData, (Object)other.clientData) && Objects.equal((Object)this.keyHandle, (Object)other.keyHandle) && Objects.equal((Object)this.signatureData, (Object)other.signatureData);
    }

    public static AuthenticateResponse fromJson(String json) {
        Preconditions.checkArgument((json.length() < 20000 ? 1 : 0) != 0, (Object)"Client response bigger than allowed");
        return (AuthenticateResponse)GSON.fromJson(json, AuthenticateResponse.class);
    }
}

