/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.json.JsonObject;
import com.yubico.u2f.exceptions.U2fException;

public class RegisterResponse
extends JsonObject {
    private static final int MAX_SIZE = 20000;
    private final String registrationData;
    private final String clientData;

    public RegisterResponse(String registrationData, String clientData) {
        this.registrationData = (String)Preconditions.checkNotNull((Object)registrationData);
        this.clientData = (String)Preconditions.checkNotNull((Object)clientData);
    }

    public String getRegistrationData() {
        return this.registrationData;
    }

    public ClientData getClientData() throws U2fException {
        return new ClientData(this.clientData);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.registrationData, this.clientData});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegisterResponse)) {
            return false;
        }
        RegisterResponse other = (RegisterResponse)obj;
        return Objects.equal((Object)this.clientData, (Object)other.clientData) && Objects.equal((Object)this.registrationData, (Object)other.registrationData);
    }

    public static RegisterResponse fromJson(String json) {
        Preconditions.checkArgument((json.length() < 20000 ? 1 : 0) != 0, (Object)"Client response bigger than allowed");
        return (RegisterResponse)GSON.fromJson(json, RegisterResponse.class);
    }
}

