/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.crypto.RandomChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateRequest;
import com.yubico.u2f.data.messages.AuthenticateRequestData;
import com.yubico.u2f.data.messages.AuthenticateResponse;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.RegisterRequest;
import com.yubico.u2f.data.messages.RegisterRequestData;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.key.RawAuthenticateResponse;
import com.yubico.u2f.data.messages.key.RawRegisterResponse;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.U2fException;
import java.util.ArrayList;
import java.util.Set;

public class U2F {
    public static final String AUTHENTICATE_TYP = "navigator.id.getAssertion";
    public static final String REGISTER_TYPE = "navigator.id.finishEnrollment";
    public static final String U2F_VERSION = "U2F_V2";
    private final Crypto crypto;
    private final ChallengeGenerator challengeGenerator;

    public U2F(Crypto crypto, ChallengeGenerator challengeGenerator) {
        this.crypto = crypto;
        this.challengeGenerator = challengeGenerator;
    }

    public U2F() {
        this(new BouncyCastleCrypto(), new RandomChallengeGenerator());
    }

    public RegisterRequest startRegistration(String appId) {
        return this.startRegistration(appId, this.challengeGenerator.generateChallenge());
    }

    public RegisterRequest startRegistration(String appId, byte[] challenge) {
        return new RegisterRequest(U2fB64Encoding.encode(challenge), appId);
    }

    public RegisterRequestData startRegistration(String appId, Iterable<? extends DeviceRegistration> devices) {
        ArrayList authenticateRequests = Lists.newArrayList();
        for (DeviceRegistration deviceRegistration : devices) {
            authenticateRequests.add(this.startAuthentication(appId, deviceRegistration));
        }
        return new RegisterRequestData(appId, devices, this, this.challengeGenerator);
    }

    public DeviceRegistration finishRegistration(RegisterRequestData registerRequestData, RegisterResponse response) throws U2fException {
        return this.finishRegistration(registerRequestData, response, null);
    }

    public DeviceRegistration finishRegistration(RegisterRequestData registerRequestData, RegisterResponse response, Set<String> facets) throws U2fException {
        return this.finishRegistration(registerRequestData.getRegisterRequest(response), response, facets);
    }

    public DeviceRegistration finishRegistration(RegisterRequest registerRequest, RegisterResponse response) throws U2fException {
        return this.finishRegistration(registerRequest, response, null);
    }

    public DeviceRegistration finishRegistration(RegisterRequest registerRequest, RegisterResponse response, Set<String> facets) throws U2fException {
        ClientData clientData = response.getClientData();
        clientData.checkContent(REGISTER_TYPE, registerRequest.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
        RawRegisterResponse rawRegisterResponse = RawRegisterResponse.fromBase64(response.getRegistrationData(), this.crypto);
        rawRegisterResponse.checkSignature(registerRequest.getAppId(), clientData.asJson());
        return rawRegisterResponse.createDevice();
    }

    public AuthenticateRequestData startAuthentication(String appId, Iterable<? extends DeviceRegistration> devices) throws U2fException {
        return new AuthenticateRequestData(appId, devices, this, this.challengeGenerator);
    }

    public AuthenticateRequest startAuthentication(String appId, DeviceRegistration deviceRegistration) {
        return this.startAuthentication(appId, deviceRegistration, this.challengeGenerator.generateChallenge());
    }

    public AuthenticateRequest startAuthentication(String appId, DeviceRegistration deviceRegistration, byte[] challenge) {
        return new AuthenticateRequest(U2fB64Encoding.encode(challenge), appId, deviceRegistration.getKeyHandle());
    }

    public DeviceRegistration finishAuthentication(AuthenticateRequestData authenticateRequestData, AuthenticateResponse response, Iterable<? extends DeviceRegistration> devices) throws U2fException {
        return this.finishAuthentication(authenticateRequestData, response, devices, null);
    }

    public DeviceRegistration finishAuthentication(AuthenticateRequestData authenticateRequestData, AuthenticateResponse response, Iterable<? extends DeviceRegistration> devices, Set<String> facets) throws U2fException {
        final AuthenticateRequest request = authenticateRequestData.getAuthenticateRequest(response);
        DeviceRegistration device = (DeviceRegistration)Iterables.find(devices, (Predicate)new Predicate<DeviceRegistration>(){

            public boolean apply(DeviceRegistration input) {
                return Objects.equal((Object)request.getKeyHandle(), (Object)input.getKeyHandle());
            }
        });
        this.finishAuthentication(request, response, device, facets);
        return device;
    }

    public void finishAuthentication(AuthenticateRequest authenticateRequest, AuthenticateResponse response, DeviceRegistration deviceRegistration) throws U2fException {
        this.finishAuthentication(authenticateRequest, response, deviceRegistration, null);
    }

    public void finishAuthentication(AuthenticateRequest authenticateRequest, AuthenticateResponse response, DeviceRegistration deviceRegistration, Set<String> facets) throws U2fException {
        ClientData clientData = response.getClientData();
        clientData.checkContent(AUTHENTICATE_TYP, authenticateRequest.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
        RawAuthenticateResponse rawAuthenticateResponse = RawAuthenticateResponse.fromBase64(response.getSignatureData(), this.crypto);
        rawAuthenticateResponse.checkSignature(authenticateRequest.getAppId(), clientData.asJson(), U2fB64Encoding.decode(deviceRegistration.getPublicKey()));
        rawAuthenticateResponse.checkUserPresence();
        deviceRegistration.checkAndUpdateCounter(rawAuthenticateResponse.getCounter());
    }
}

