/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.yubico.u2f.data.messages.json.JsonObject;
import com.yubico.u2f.data.messages.key.util.ByteInputStream;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.InvalidDeviceCounterException;
import com.yubico.u2f.exceptions.U2fException;
import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class DeviceRegistration
extends JsonObject
implements Serializable {
    private static final long serialVersionUID = -142942195464329902L;
    public static final long INITIAL_COUNTER_VALUE = -1L;
    private final String keyHandle;
    private final String publicKey;
    private final String attestationCert;
    private long counter;

    private DeviceRegistration() {
        this.keyHandle = null;
        this.publicKey = null;
        this.attestationCert = null;
    }

    public DeviceRegistration(String keyHandle, String publicKey, X509Certificate attestationCert, long counter) throws U2fException {
        this.keyHandle = keyHandle;
        this.publicKey = publicKey;
        try {
            this.attestationCert = U2fB64Encoding.encode(attestationCert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new U2fException("Invalid attestation certificate", e);
        }
        this.counter = counter;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate getAttestationCertificate() throws CertificateException, NoSuchFieldException {
        if (this.attestationCert == null) {
            throw new NoSuchFieldException();
        }
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteInputStream(U2fB64Encoding.decode(this.attestationCert)));
    }

    public long getCounter() {
        return this.counter;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyHandle, this.publicKey, this.attestationCert});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeviceRegistration)) {
            return false;
        }
        DeviceRegistration that = (DeviceRegistration)obj;
        return Objects.equal((Object)this.keyHandle, (Object)that.keyHandle) && Objects.equal((Object)this.publicKey, (Object)that.publicKey) && Objects.equal((Object)this.attestationCert, (Object)that.attestationCert);
    }

    public String toString() {
        X509Certificate certificate = null;
        try {
            certificate = this.getAttestationCertificate();
        }
        catch (CertificateException e) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("Key handle", (Object)this.keyHandle).add("Public key", (Object)this.publicKey).add("Counter", this.counter).add("Attestation certificate", (Object)certificate).toString();
    }

    public static DeviceRegistration fromJson(String json) {
        return (DeviceRegistration)GSON.fromJson(json, DeviceRegistration.class);
    }

    @Override
    public String toJson() {
        return GSON.toJson((Object)new DeviceWithoutCertificate(this.keyHandle, this.publicKey, this.counter));
    }

    public String toJsonWithAttestationCert() {
        return super.toJson();
    }

    public void checkAndUpdateCounter(int clientCounter) throws U2fException {
        if ((long)clientCounter <= this.counter) {
            throw new InvalidDeviceCounterException();
        }
        this.counter = clientCounter;
    }

    private static class DeviceWithoutCertificate {
        private final String keyHandle;
        private final String publicKey;
        private final long counter;

        private DeviceWithoutCertificate(String keyHandle, String publicKey, long counter) {
            this.keyHandle = keyHandle;
            this.publicKey = publicKey;
            this.counter = counter;
        }
    }
}

