/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.yubico.u2f.data.messages.json.JsonObject;
import com.yubico.u2f.data.messages.json.Persistable;

public class AuthenticateRequest
extends JsonObject
implements Persistable {
    private static final long serialVersionUID = -27808961388655010L;
    private final String version = "U2F_V2";
    private final String challenge;
    private final String appId;
    private final String keyHandle;

    private AuthenticateRequest() {
        this.challenge = null;
        this.appId = null;
        this.keyHandle = null;
    }

    public AuthenticateRequest(String challenge, String appId, String keyHandle) {
        this.challenge = (String)Preconditions.checkNotNull((Object)challenge);
        this.appId = (String)Preconditions.checkNotNull((Object)appId);
        this.keyHandle = (String)Preconditions.checkNotNull((Object)keyHandle);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{"U2F_V2", this.challenge, this.appId, this.keyHandle});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuthenticateRequest)) {
            return false;
        }
        AuthenticateRequest other = (AuthenticateRequest)obj;
        return Objects.equal((Object)this.appId, (Object)other.appId) && Objects.equal((Object)this.challenge, (Object)other.challenge) && Objects.equal((Object)this.keyHandle, (Object)other.keyHandle) && Objects.equal((Object)"U2F_V2", (Object)other.version);
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getRequestId() {
        return this.challenge;
    }

    public static AuthenticateRequest fromJson(String json) {
        return (AuthenticateRequest)GSON.fromJson(json, AuthenticateRequest.class);
    }
}

