/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.yubico.u2f.U2F;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateRequest;
import com.yubico.u2f.data.messages.AuthenticateResponse;
import com.yubico.u2f.data.messages.json.JsonObject;
import com.yubico.u2f.data.messages.json.Persistable;
import com.yubico.u2f.exceptions.NoDevicesRegisteredException;
import com.yubico.u2f.exceptions.U2fException;
import java.util.List;

public class AuthenticateRequestData
extends JsonObject
implements Persistable {
    private static final long serialVersionUID = 35378338769078256L;
    private final List<AuthenticateRequest> authenticateRequests;

    public AuthenticateRequestData(String appId, Iterable<? extends DeviceRegistration> devices, U2F u2f, ChallengeGenerator challengeGenerator) throws U2fException {
        if (Iterables.isEmpty(devices)) {
            throw new NoDevicesRegisteredException();
        }
        ImmutableList.Builder requestBuilder = ImmutableList.builder();
        byte[] challenge = challengeGenerator.generateChallenge();
        for (DeviceRegistration deviceRegistration : devices) {
            requestBuilder.add((Object)u2f.startAuthentication(appId, deviceRegistration, challenge));
        }
        this.authenticateRequests = requestBuilder.build();
    }

    public List<AuthenticateRequest> getAuthenticateRequests() {
        return ImmutableList.copyOf(this.authenticateRequests);
    }

    public AuthenticateRequest getAuthenticateRequest(AuthenticateResponse response) throws U2fException {
        if (!Objects.equal((Object)this.getRequestId(), (Object)response.getRequestId())) {
            throw new U2fException("Wrong request for response data");
        }
        for (AuthenticateRequest request : this.authenticateRequests) {
            if (!Objects.equal((Object)request.getKeyHandle(), (Object)response.getKeyHandle())) continue;
            return request;
        }
        throw new U2fException("Unknown keyHandle");
    }

    @Override
    public String getRequestId() {
        return ((AuthenticateRequest)Iterables.getFirst(this.authenticateRequests, null)).getChallenge();
    }

    public static AuthenticateRequestData fromJson(String json) {
        return (AuthenticateRequestData)GSON.fromJson(json, AuthenticateRequestData.class);
    }
}

