/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.yubico.u2f.U2F;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateRequest;
import com.yubico.u2f.data.messages.RegisterRequest;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.json.JsonObject;
import com.yubico.u2f.data.messages.json.Persistable;
import java.util.List;

public class RegisterRequestData
extends JsonObject
implements Persistable {
    private static final long serialVersionUID = 60855174227617680L;
    private final List<AuthenticateRequest> authenticateRequests;
    private final List<RegisterRequest> registerRequests;

    public RegisterRequestData(String appId, Iterable<? extends DeviceRegistration> devices, U2F u2f, ChallengeGenerator challengeGenerator) {
        ImmutableList.Builder authenticateRequests = ImmutableList.builder();
        for (DeviceRegistration deviceRegistration : devices) {
            authenticateRequests.add((Object)u2f.startAuthentication(appId, deviceRegistration));
        }
        this.authenticateRequests = authenticateRequests.build();
        this.registerRequests = ImmutableList.of((Object)u2f.startRegistration(appId, challengeGenerator.generateChallenge()));
    }

    private RegisterRequestData() {
        this.authenticateRequests = null;
        this.registerRequests = null;
    }

    public List<AuthenticateRequest> getAuthenticateRequests() {
        return ImmutableList.copyOf(this.authenticateRequests);
    }

    public List<RegisterRequest> getRegisterRequests() {
        return ImmutableList.copyOf(this.registerRequests);
    }

    public RegisterRequest getRegisterRequest(RegisterResponse response) {
        return (RegisterRequest)Iterables.getOnlyElement(this.registerRequests);
    }

    @Override
    public String getRequestId() {
        return ((RegisterRequest)Iterables.getOnlyElement(this.registerRequests)).getChallenge();
    }

    public static RegisterRequestData fromJson(String json) {
        return (RegisterRequestData)GSON.fromJson(json, RegisterRequestData.class);
    }
}

