/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages.key;

import com.google.common.base.Objects;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.key.util.ByteInputStream;
import com.yubico.u2f.data.messages.key.util.ByteSink;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.U2fException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class RawRegisterResponse {
    public static final byte REGISTRATION_RESERVED_BYTE_VALUE = 5;
    public static final byte REGISTRATION_SIGNED_RESERVED_BYTE_VALUE = 0;
    private final Crypto crypto;
    final byte[] userPublicKey;
    final byte[] keyHandle;
    final X509Certificate attestationCertificate;
    final byte[] signature;

    public RawRegisterResponse(byte[] userPublicKey, byte[] keyHandle, X509Certificate attestationCertificate, byte[] signature) {
        this(userPublicKey, keyHandle, attestationCertificate, signature, new BouncyCastleCrypto());
    }

    public RawRegisterResponse(byte[] userPublicKey, byte[] keyHandle, X509Certificate attestationCertificate, byte[] signature, Crypto crypto) {
        this.userPublicKey = userPublicKey;
        this.keyHandle = keyHandle;
        this.attestationCertificate = attestationCertificate;
        this.signature = signature;
        this.crypto = crypto;
    }

    public static RawRegisterResponse fromBase64(String rawDataBase64, Crypto crypto) throws U2fException {
        ByteInputStream bytes = new ByteInputStream(U2fB64Encoding.decode(rawDataBase64));
        byte reservedByte = bytes.readSigned();
        if (reservedByte != 5) {
            throw new U2fException("Incorrect value of reserved byte. Expected: 5. Was: " + reservedByte);
        }
        try {
            return new RawRegisterResponse(bytes.read(65), bytes.read(bytes.readUnsigned()), (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bytes), bytes.readAll(), crypto);
        }
        catch (CertificateException e) {
            throw new U2fException("Error when parsing attestation certificate", e);
        }
    }

    public void checkSignature(String appId, String clientData) throws U2fException {
        byte[] signedBytes = RawRegisterResponse.packBytesToSign(this.crypto.hash(appId), this.crypto.hash(clientData), this.keyHandle, this.userPublicKey);
        this.crypto.checkSignature(this.attestationCertificate, signedBytes, this.signature);
    }

    public static byte[] packBytesToSign(byte[] appIdHash, byte[] clientDataHash, byte[] keyHandle, byte[] userPublicKey) {
        return ByteSink.create().put((byte)0).put(appIdHash).put(clientDataHash).put(keyHandle).put(userPublicKey).toByteArray();
    }

    public DeviceRegistration createDevice() throws U2fException {
        return new DeviceRegistration(U2fB64Encoding.encode(this.keyHandle), U2fB64Encoding.encode(this.userPublicKey), this.attestationCertificate, -1L);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.userPublicKey, this.keyHandle, this.attestationCertificate, this.signature});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RawRegisterResponse)) {
            return false;
        }
        RawRegisterResponse other = (RawRegisterResponse)obj;
        return Objects.equal((Object)this.attestationCertificate, (Object)other.attestationCertificate) && Arrays.equals(this.keyHandle, other.keyHandle) && Arrays.equals(this.signature, other.signature) && Arrays.equals(this.userPublicKey, other.userPublicKey);
    }
}

