/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.crypto.RandomChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateRequest;
import com.yubico.u2f.data.messages.AuthenticateResponse;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.RegisterRequest;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.key.RawAuthenticateResponse;
import com.yubico.u2f.data.messages.key.RawRegisterResponse;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.DeviceCompromisedException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.util.Set;

public class U2fPrimitives {
    public static final String AUTHENTICATE_TYP = "navigator.id.getAssertion";
    public static final String REGISTER_TYPE = "navigator.id.finishEnrollment";
    public static final String U2F_VERSION = "U2F_V2";
    private final Crypto crypto;
    private final ChallengeGenerator challengeGenerator;

    public U2fPrimitives(Crypto crypto, ChallengeGenerator challengeGenerator) {
        this.crypto = crypto;
        this.challengeGenerator = challengeGenerator;
    }

    public U2fPrimitives() {
        this(new BouncyCastleCrypto(), new RandomChallengeGenerator());
    }

    public RegisterRequest startRegistration(String appId) {
        return this.startRegistration(appId, this.challengeGenerator.generateChallenge());
    }

    public RegisterRequest startRegistration(String appId, byte[] challenge) {
        return new RegisterRequest(U2fB64Encoding.encode(challenge), appId);
    }

    public DeviceRegistration finishRegistration(RegisterRequest registerRequest, RegisterResponse response) throws U2fBadInputException {
        return this.finishRegistration(registerRequest, response, null);
    }

    public DeviceRegistration finishRegistration(RegisterRequest registerRequest, RegisterResponse response, Set<String> facets) throws U2fBadInputException {
        ClientData clientData = response.getClientData();
        clientData.checkContent(REGISTER_TYPE, registerRequest.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
        RawRegisterResponse rawRegisterResponse = RawRegisterResponse.fromBase64(response.getRegistrationData(), this.crypto);
        rawRegisterResponse.checkSignature(registerRequest.getAppId(), clientData.asJson());
        return rawRegisterResponse.createDevice();
    }

    public AuthenticateRequest startAuthentication(String appId, DeviceRegistration deviceRegistration) {
        return this.startAuthentication(appId, deviceRegistration, this.challengeGenerator.generateChallenge());
    }

    public AuthenticateRequest startAuthentication(String appId, DeviceRegistration deviceRegistration, byte[] challenge) {
        Preconditions.checkArgument((!deviceRegistration.isCompromised() ? 1 : 0) != 0, (Object)"Device has been marked as compromised, cannot authenticate");
        return new AuthenticateRequest(U2fB64Encoding.encode(challenge), appId, deviceRegistration.getKeyHandle());
    }

    public void finishAuthentication(AuthenticateRequest authenticateRequest, AuthenticateResponse response, DeviceRegistration deviceRegistration) throws U2fBadInputException, DeviceCompromisedException {
        this.finishAuthentication(authenticateRequest, response, deviceRegistration, null);
    }

    public void finishAuthentication(AuthenticateRequest authenticateRequest, AuthenticateResponse response, DeviceRegistration deviceRegistration, Set<String> facets) throws U2fBadInputException, DeviceCompromisedException {
        Preconditions.checkArgument((!deviceRegistration.isCompromised() ? 1 : 0) != 0, (Object)"Device has been marked as compromised, cannot authenticate");
        Preconditions.checkArgument((boolean)authenticateRequest.getKeyHandle().equals(deviceRegistration.getKeyHandle()), (Object)"Wrong DeviceRegistration for the given AuthenticateRequest");
        if (!deviceRegistration.getKeyHandle().equals(response.getKeyHandle())) {
            throw new U2fBadInputException("KeyHandle of AuthenticateResponse does not match");
        }
        ClientData clientData = response.getClientData();
        clientData.checkContent(AUTHENTICATE_TYP, authenticateRequest.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
        RawAuthenticateResponse rawAuthenticateResponse = RawAuthenticateResponse.fromBase64(response.getSignatureData(), this.crypto);
        rawAuthenticateResponse.checkSignature(authenticateRequest.getAppId(), clientData.asJson(), U2fB64Encoding.decode(deviceRegistration.getPublicKey()));
        rawAuthenticateResponse.checkUserPresence();
        deviceRegistration.checkAndUpdateCounter(rawAuthenticateResponse.getCounter());
    }
}

