/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.yubico.u2f.U2fPrimitives;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateRequest;
import com.yubico.u2f.data.messages.AuthenticateResponse;
import com.yubico.u2f.data.messages.json.JsonSerializable;
import com.yubico.u2f.data.messages.json.Persistable;
import com.yubico.u2f.exceptions.NoEligableDevicesException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.util.List;

public class AuthenticateRequestData
extends JsonSerializable
implements Persistable {
    private static final long serialVersionUID = 35378338769078256L;
    @JsonProperty
    private final List<AuthenticateRequest> authenticateRequests;

    @JsonCreator
    private AuthenticateRequestData(@JsonProperty(value="authenticateRequests") List<AuthenticateRequest> authenticateRequests) {
        this.authenticateRequests = authenticateRequests;
    }

    public AuthenticateRequestData(String appId, Iterable<? extends DeviceRegistration> devices, U2fPrimitives u2f, ChallengeGenerator challengeGenerator) throws U2fBadInputException, NoEligableDevicesException {
        ImmutableList.Builder requestBuilder = ImmutableList.builder();
        byte[] challenge = challengeGenerator.generateChallenge();
        for (DeviceRegistration deviceRegistration : devices) {
            if (deviceRegistration.isCompromised()) continue;
            requestBuilder.add((Object)u2f.startAuthentication(appId, deviceRegistration, challenge));
        }
        this.authenticateRequests = requestBuilder.build();
        if (this.authenticateRequests.isEmpty()) {
            if (Iterables.isEmpty(devices)) {
                throw new NoEligableDevicesException(devices, "No devices registrered");
            }
            throw new NoEligableDevicesException(devices, "All devices compromised");
        }
    }

    public List<AuthenticateRequest> getAuthenticateRequests() {
        return ImmutableList.copyOf(this.authenticateRequests);
    }

    public AuthenticateRequest getAuthenticateRequest(AuthenticateResponse response) throws U2fBadInputException {
        Preconditions.checkArgument((boolean)Objects.equal((Object)this.getRequestId(), (Object)response.getRequestId()), (Object)"Wrong request for response data");
        for (AuthenticateRequest request : this.authenticateRequests) {
            if (!Objects.equal((Object)request.getKeyHandle(), (Object)response.getKeyHandle())) continue;
            return request;
        }
        throw new U2fBadInputException("Responses keyHandle does not match any contained request");
    }

    @Override
    public String getRequestId() {
        return this.authenticateRequests.get(0).getChallenge();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.authenticateRequests});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuthenticateRequestData)) {
            return false;
        }
        AuthenticateRequestData other = (AuthenticateRequestData)obj;
        return Objects.equal(this.authenticateRequests, other.authenticateRequests);
    }

    public static AuthenticateRequestData fromJson(String json) throws U2fBadInputException {
        return AuthenticateRequestData.fromJson(json, AuthenticateRequestData.class);
    }
}

