/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.yubico.u2f.U2fPrimitives;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateRequest;
import com.yubico.u2f.data.messages.RegisterRequest;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.json.JsonSerializable;
import com.yubico.u2f.data.messages.json.Persistable;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.util.List;

public class RegisterRequestData
extends JsonSerializable
implements Persistable {
    private static final long serialVersionUID = 60855174227617680L;
    @JsonProperty
    private final List<AuthenticateRequest> authenticateRequests;
    @JsonProperty
    private final List<RegisterRequest> registerRequests;

    private RegisterRequestData(@JsonProperty(value="authenticateRequests") List<AuthenticateRequest> authenticateRequests, @JsonProperty(value="registerRequests") List<RegisterRequest> registerRequests) {
        this.authenticateRequests = authenticateRequests;
        this.registerRequests = registerRequests;
    }

    public RegisterRequestData(String appId, Iterable<? extends DeviceRegistration> devices, U2fPrimitives u2f, ChallengeGenerator challengeGenerator) {
        ImmutableList.Builder authenticateRequests = ImmutableList.builder();
        for (DeviceRegistration deviceRegistration : devices) {
            if (deviceRegistration.isCompromised()) continue;
            authenticateRequests.add((Object)u2f.startAuthentication(appId, deviceRegistration));
        }
        this.authenticateRequests = authenticateRequests.build();
        this.registerRequests = ImmutableList.of((Object)u2f.startRegistration(appId, challengeGenerator.generateChallenge()));
    }

    public List<AuthenticateRequest> getAuthenticateRequests() {
        return ImmutableList.copyOf(this.authenticateRequests);
    }

    public List<RegisterRequest> getRegisterRequests() {
        return ImmutableList.copyOf(this.registerRequests);
    }

    public RegisterRequest getRegisterRequest(RegisterResponse response) {
        return (RegisterRequest)Iterables.getOnlyElement(this.registerRequests);
    }

    @Override
    public String getRequestId() {
        return ((RegisterRequest)Iterables.getOnlyElement(this.registerRequests)).getChallenge();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.authenticateRequests, this.registerRequests});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegisterRequestData)) {
            return false;
        }
        RegisterRequestData other = (RegisterRequestData)obj;
        return Objects.equal(this.authenticateRequests, other.authenticateRequests) && Objects.equal(this.registerRequests, other.registerRequests);
    }

    public static RegisterRequestData fromJson(String json) throws U2fBadInputException {
        return RegisterRequestData.fromJson(json, RegisterRequestData.class);
    }
}

