/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.json.JsonSerializable;
import com.yubico.u2f.data.messages.json.Persistable;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RegisterResponse
extends JsonSerializable
implements Persistable {
    private static final int MAX_SIZE = 20000;
    @JsonProperty
    private final String registrationData;
    @JsonProperty
    private final String clientData;
    private transient ClientData clientDataRef;

    @JsonCreator
    public RegisterResponse(@JsonProperty(value="registrationData") String registrationData, @JsonProperty(value="clientData") String clientData) throws U2fBadInputException {
        this.registrationData = (String)Preconditions.checkNotNull((Object)registrationData);
        this.clientData = (String)Preconditions.checkNotNull((Object)clientData);
        this.clientDataRef = new ClientData(clientData);
    }

    public String getRegistrationData() {
        return this.registrationData;
    }

    @JsonIgnore
    public ClientData getClientData() {
        return this.clientDataRef;
    }

    @Override
    public String getRequestId() {
        return this.getClientData().getChallenge();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.registrationData, this.clientData});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegisterResponse)) {
            return false;
        }
        RegisterResponse other = (RegisterResponse)obj;
        return Objects.equal((Object)this.clientData, (Object)other.clientData) && Objects.equal((Object)this.registrationData, (Object)other.registrationData);
    }

    public static RegisterResponse fromJson(String json) throws U2fBadInputException {
        Preconditions.checkArgument((json.length() < 20000 ? 1 : 0) != 0, (Object)"Client response bigger than allowed");
        return JsonSerializable.fromJson(json, RegisterResponse.class);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.clientDataRef = new ClientData(this.clientData);
        }
        catch (U2fBadInputException e) {
            throw new IOException(e);
        }
    }
}

