/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages.key;

import com.google.common.base.Objects;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.data.messages.key.util.ByteInputStream;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.util.Arrays;

public class RawAuthenticateResponse {
    public static final byte USER_PRESENT_FLAG = 1;
    private final byte userPresence;
    private final long counter;
    private final byte[] signature;
    private final Crypto crypto;

    public RawAuthenticateResponse(byte userPresence, long counter, byte[] signature) {
        this(userPresence, counter, signature, new BouncyCastleCrypto());
    }

    public RawAuthenticateResponse(byte userPresence, long counter, byte[] signature, Crypto crypto) {
        this.userPresence = userPresence;
        this.counter = counter;
        this.signature = signature;
        this.crypto = crypto;
    }

    public static RawAuthenticateResponse fromBase64(String rawDataBase64, Crypto crypto) {
        ByteInputStream bytes = new ByteInputStream(U2fB64Encoding.decode(rawDataBase64));
        return new RawAuthenticateResponse(bytes.readSigned(), bytes.readInteger(), bytes.readAll(), crypto);
    }

    public void checkSignature(String appId, String clientData, byte[] publicKey) throws U2fBadInputException {
        byte[] signedBytes = RawAuthenticateResponse.packBytesToSign(this.crypto.hash(appId), this.userPresence, this.counter, this.crypto.hash(clientData));
        this.crypto.checkSignature(this.crypto.decodePublicKey(publicKey), signedBytes, this.signature);
    }

    public static byte[] packBytesToSign(byte[] appIdHash, byte userPresence, long counter, byte[] challengeHash) {
        ByteArrayDataOutput encoded = ByteStreams.newDataOutput();
        encoded.write(appIdHash);
        encoded.write((int)userPresence);
        encoded.writeInt((int)counter);
        encoded.write(challengeHash);
        return encoded.toByteArray();
    }

    public byte getUserPresence() {
        return this.userPresence;
    }

    public long getCounter() {
        return this.counter;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.userPresence, this.counter, this.signature});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RawAuthenticateResponse)) {
            return false;
        }
        RawAuthenticateResponse other = (RawAuthenticateResponse)obj;
        return Objects.equal((Object)this.counter, (Object)other.counter) && Arrays.equals(this.signature, this.signature) && Objects.equal((Object)this.userPresence, (Object)other.userPresence);
    }

    public void checkUserPresence() throws U2fBadInputException {
        if (this.userPresence != 1) {
            throw new U2fBadInputException("User presence invalid during authentication");
        }
    }
}

