/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.yubico.u2f.AppId;
import com.yubico.u2f.U2fPrimitives;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.crypto.RandomChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateRequest;
import com.yubico.u2f.data.messages.AuthenticateRequestData;
import com.yubico.u2f.data.messages.AuthenticateResponse;
import com.yubico.u2f.data.messages.RegisterRequestData;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.exceptions.DeviceCompromisedException;
import com.yubico.u2f.exceptions.NoEligableDevicesException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.util.Set;

public class U2F {
    private final ChallengeGenerator challengeGenerator = new RandomChallengeGenerator();
    private final U2fPrimitives primitives = new U2fPrimitives(new BouncyCastleCrypto(), this.challengeGenerator);
    private final boolean validateAppId;

    public U2F() {
        this(true);
    }

    public static U2F withoutAppIdValidation() {
        return new U2F(false);
    }

    private U2F(boolean validateAppId) {
        this.validateAppId = validateAppId;
    }

    public RegisterRequestData startRegistration(String appId, Iterable<? extends DeviceRegistration> devices) {
        if (this.validateAppId) {
            AppId.checkIsValid(appId);
        }
        return new RegisterRequestData(appId, devices, this.primitives, this.challengeGenerator);
    }

    public AuthenticateRequestData startAuthentication(String appId, Iterable<? extends DeviceRegistration> devices) throws U2fBadInputException, NoEligableDevicesException {
        if (this.validateAppId) {
            AppId.checkIsValid(appId);
        }
        return new AuthenticateRequestData(appId, devices, this.primitives, this.challengeGenerator);
    }

    public DeviceRegistration finishRegistration(RegisterRequestData registerRequestData, RegisterResponse response) throws U2fBadInputException {
        return this.finishRegistration(registerRequestData, response, null);
    }

    public DeviceRegistration finishRegistration(RegisterRequestData registerRequestData, RegisterResponse response, Set<String> facets) throws U2fBadInputException {
        return this.primitives.finishRegistration(registerRequestData.getRegisterRequest(response), response, facets);
    }

    public DeviceRegistration finishAuthentication(AuthenticateRequestData authenticateRequestData, AuthenticateResponse response, Iterable<? extends DeviceRegistration> devices) throws U2fBadInputException, DeviceCompromisedException {
        return this.finishAuthentication(authenticateRequestData, response, devices, null);
    }

    public DeviceRegistration finishAuthentication(AuthenticateRequestData authenticateRequestData, AuthenticateResponse response, Iterable<? extends DeviceRegistration> devices, Set<String> facets) throws U2fBadInputException, DeviceCompromisedException {
        final AuthenticateRequest request = authenticateRequestData.getAuthenticateRequest(response);
        DeviceRegistration device = (DeviceRegistration)Iterables.find(devices, (Predicate)new Predicate<DeviceRegistration>(){

            public boolean apply(DeviceRegistration input) {
                return Objects.equal((Object)request.getKeyHandle(), (Object)input.getKeyHandle());
            }
        });
        if (device.isCompromised()) {
            throw new DeviceCompromisedException(device, "The device is marked as possibly compromised, and cannot be authenticated");
        }
        this.primitives.finishAuthentication(request, response, device, facets);
        return device;
    }
}

