/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.json.JsonSerializable;
import com.yubico.u2f.data.messages.json.Persistable;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthenticateResponse
extends JsonSerializable
implements Persistable {
    private static final int MAX_SIZE = 20000;
    @JsonProperty
    private final String clientData;
    @JsonIgnore
    private transient ClientData clientDataRef;
    @JsonProperty
    private final String signatureData;
    @JsonProperty
    private final String keyHandle;

    @JsonCreator
    public AuthenticateResponse(@JsonProperty(value="clientData") String clientData, @JsonProperty(value="signatureData") String signatureData, @JsonProperty(value="keyHandle") String keyHandle) throws U2fBadInputException {
        this.clientData = (String)Preconditions.checkNotNull((Object)clientData);
        this.signatureData = (String)Preconditions.checkNotNull((Object)signatureData);
        this.keyHandle = (String)Preconditions.checkNotNull((Object)keyHandle);
        this.clientDataRef = new ClientData(clientData);
    }

    @JsonIgnore
    public ClientData getClientData() {
        return this.clientDataRef;
    }

    public String getSignatureData() {
        return this.signatureData;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    @Override
    public String getRequestId() {
        return this.getClientData().getChallenge();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientData, this.signatureData, this.keyHandle});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuthenticateResponse)) {
            return false;
        }
        AuthenticateResponse other = (AuthenticateResponse)obj;
        return Objects.equal((Object)this.clientData, (Object)other.clientData) && Objects.equal((Object)this.keyHandle, (Object)other.keyHandle) && Objects.equal((Object)this.signatureData, (Object)other.signatureData);
    }

    public static AuthenticateResponse fromJson(String json) throws U2fBadInputException {
        Preconditions.checkArgument((json.length() < 20000 ? 1 : 0) != 0, (Object)"Client response bigger than allowed");
        return AuthenticateResponse.fromJson(json, AuthenticateResponse.class);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.clientDataRef = new ClientData(this.clientData);
        }
        catch (U2fBadInputException e) {
            throw new IOException(e);
        }
    }
}

