/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.yubico.u2f.data.messages.json.JsonSerializable;
import com.yubico.u2f.data.messages.json.Persistable;
import com.yubico.u2f.exceptions.U2fBadInputException;

public class RegisterRequest
extends JsonSerializable
implements Persistable {
    private static final long serialVersionUID = 24349091760814188L;
    @JsonProperty
    private final String version = "U2F_V2";
    @JsonProperty
    private final String challenge;
    @JsonProperty
    private final String appId;

    public String getChallenge() {
        return this.challenge;
    }

    @JsonCreator
    public RegisterRequest(@JsonProperty(value="challenge") String challenge, @JsonProperty(value="appId") String appId) {
        this.challenge = (String)Preconditions.checkNotNull((Object)challenge);
        this.appId = (String)Preconditions.checkNotNull((Object)appId);
    }

    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getRequestId() {
        return this.getChallenge();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{"U2F_V2", this.challenge, this.appId});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegisterRequest)) {
            return false;
        }
        RegisterRequest other = (RegisterRequest)obj;
        return Objects.equal((Object)this.appId, (Object)other.appId) && Objects.equal((Object)this.challenge, (Object)other.challenge) && Objects.equal((Object)"U2F_V2", (Object)other.version);
    }

    public static RegisterRequest fromJson(String json) throws U2fBadInputException {
        return RegisterRequest.fromJson(json, RegisterRequest.class);
    }
}

