/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.yubico.u2f.U2fPrimitives;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.AuthenticateRequest;
import com.yubico.u2f.data.messages.AuthenticateResponse;
import com.yubico.u2f.data.messages.json.JsonSerializable;
import com.yubico.u2f.data.messages.json.Persistable;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.NoEligibleDevicesException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.util.List;
import lombok.Generated;

public class AuthenticateRequestData
extends JsonSerializable
implements Persistable {
    private static final long serialVersionUID = 35378338769078256L;
    @JsonProperty
    private final String appId;
    @JsonProperty
    private final String challenge;
    @JsonProperty
    private final List<AuthenticateRequest> authenticateRequests;

    @JsonCreator
    public AuthenticateRequestData(@JsonProperty(value="appId") String appId, @JsonProperty(value="challenge") String challenge, @JsonProperty(value="authenticateRequests") List<AuthenticateRequest> authenticateRequests) {
        this.appId = appId;
        this.challenge = challenge;
        this.authenticateRequests = authenticateRequests;
    }

    public AuthenticateRequestData(String appId, Iterable<? extends DeviceRegistration> devices, U2fPrimitives u2f, ChallengeGenerator challengeGenerator) throws U2fBadInputException, NoEligibleDevicesException {
        this.appId = appId;
        byte[] challenge = challengeGenerator.generateChallenge();
        this.challenge = U2fB64Encoding.encode(challenge);
        ImmutableList.Builder requestBuilder = ImmutableList.builder();
        for (DeviceRegistration deviceRegistration : devices) {
            if (deviceRegistration.isCompromised()) continue;
            requestBuilder.add((Object)u2f.startAuthentication(appId, deviceRegistration, challenge));
        }
        this.authenticateRequests = requestBuilder.build();
        if (this.authenticateRequests.isEmpty()) {
            if (Iterables.isEmpty(devices)) {
                throw new NoEligibleDevicesException((Iterable<? extends DeviceRegistration>)ImmutableList.of(), "No devices registrered");
            }
            throw new NoEligibleDevicesException(devices, "All devices compromised");
        }
    }

    public List<AuthenticateRequest> getAuthenticateRequests() {
        return ImmutableList.copyOf(this.authenticateRequests);
    }

    public AuthenticateRequest getAuthenticateRequest(AuthenticateResponse response) throws U2fBadInputException {
        Preconditions.checkArgument((boolean)Objects.equal((Object)this.getRequestId(), (Object)response.getRequestId()), (Object)"Wrong request for response data");
        for (AuthenticateRequest request : this.authenticateRequests) {
            if (!Objects.equal((Object)request.getKeyHandle(), (Object)response.getKeyHandle())) continue;
            return request;
        }
        throw new U2fBadInputException("Responses keyHandle does not match any contained request");
    }

    @Override
    public String getRequestId() {
        return this.authenticateRequests.get(0).getChallenge();
    }

    public static AuthenticateRequestData fromJson(String json) throws U2fBadInputException {
        return AuthenticateRequestData.fromJson(json, AuthenticateRequestData.class);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticateRequestData)) {
            return false;
        }
        AuthenticateRequestData other = (AuthenticateRequestData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appId = this.appId;
        String other$appId = other.appId;
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$challenge = this.challenge;
        String other$challenge = other.challenge;
        if (this$challenge == null ? other$challenge != null : !this$challenge.equals(other$challenge)) {
            return false;
        }
        List<AuthenticateRequest> this$authenticateRequests = this.getAuthenticateRequests();
        List<AuthenticateRequest> other$authenticateRequests = other.getAuthenticateRequests();
        return !(this$authenticateRequests == null ? other$authenticateRequests != null : !((Object)this$authenticateRequests).equals(other$authenticateRequests));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticateRequestData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.appId;
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $challenge = this.challenge;
        result = result * 59 + ($challenge == null ? 43 : $challenge.hashCode());
        List<AuthenticateRequest> $authenticateRequests = this.getAuthenticateRequests();
        result = result * 59 + ($authenticateRequests == null ? 43 : ((Object)$authenticateRequests).hashCode());
        return result;
    }
}

