/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages.key;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.data.messages.key.util.ByteInputStream;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.util.Arrays;
import lombok.Generated;

public class RawAuthenticateResponse {
    public static final byte USER_PRESENT_FLAG = 1;
    private final byte userPresence;
    private final long counter;
    private final byte[] signature;
    private final Crypto crypto;

    public RawAuthenticateResponse(byte userPresence, long counter, byte[] signature) {
        this(userPresence, counter, signature, new BouncyCastleCrypto());
    }

    public RawAuthenticateResponse(byte userPresence, long counter, byte[] signature, Crypto crypto) {
        this.userPresence = userPresence;
        this.counter = counter;
        this.signature = signature;
        this.crypto = crypto;
    }

    public static RawAuthenticateResponse fromBase64(String rawDataBase64, Crypto crypto) {
        ByteInputStream bytes = new ByteInputStream(U2fB64Encoding.decode(rawDataBase64));
        return new RawAuthenticateResponse(bytes.readSigned(), bytes.readInteger(), bytes.readAll(), crypto);
    }

    public void checkSignature(String appId, String clientData, byte[] publicKey) throws U2fBadInputException {
        byte[] signedBytes = RawAuthenticateResponse.packBytesToSign(this.crypto.hash(appId), this.userPresence, this.counter, this.crypto.hash(clientData));
        this.crypto.checkSignature(this.crypto.decodePublicKey(publicKey), signedBytes, this.signature);
    }

    public static byte[] packBytesToSign(byte[] appIdHash, byte userPresence, long counter, byte[] challengeHash) {
        ByteArrayDataOutput encoded = ByteStreams.newDataOutput();
        encoded.write(appIdHash);
        encoded.write((int)userPresence);
        encoded.writeInt((int)counter);
        encoded.write(challengeHash);
        return encoded.toByteArray();
    }

    public byte getUserPresence() {
        return this.userPresence;
    }

    public long getCounter() {
        return this.counter;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void checkUserPresence() throws U2fBadInputException {
        if (this.userPresence != 1) {
            throw new U2fBadInputException("User presence invalid during authentication");
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawAuthenticateResponse)) {
            return false;
        }
        RawAuthenticateResponse other = (RawAuthenticateResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUserPresence() != other.getUserPresence()) {
            return false;
        }
        if (this.getCounter() != other.getCounter()) {
            return false;
        }
        return Arrays.equals(this.getSignature(), other.getSignature());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawAuthenticateResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUserPresence();
        long $counter = this.getCounter();
        result = result * 59 + (int)($counter >>> 32 ^ $counter);
        result = result * 59 + Arrays.hashCode(this.getSignature());
        return result;
    }
}

