/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.yubico.u2f.AppId;
import com.yubico.u2f.U2fPrimitives;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.crypto.RandomChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.RegisterRequestData;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.SignRequest;
import com.yubico.u2f.data.messages.SignRequestData;
import com.yubico.u2f.data.messages.SignResponse;
import com.yubico.u2f.exceptions.DeviceCompromisedException;
import com.yubico.u2f.exceptions.NoEligibleDevicesException;
import com.yubico.u2f.exceptions.U2fAuthenticationException;
import com.yubico.u2f.exceptions.U2fBadConfigurationException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import com.yubico.u2f.exceptions.U2fRegistrationException;
import java.util.Set;

public class U2F {
    private final ChallengeGenerator challengeGenerator = new RandomChallengeGenerator();
    private final U2fPrimitives primitives = new U2fPrimitives(new BouncyCastleCrypto(), this.challengeGenerator);
    private final boolean validateAppId;

    public U2F() {
        this(true);
    }

    public static U2F withoutAppIdValidation() {
        return new U2F(false);
    }

    private U2F(boolean validateAppId) {
        this.validateAppId = validateAppId;
    }

    public RegisterRequestData startRegistration(String appId, Iterable<? extends DeviceRegistration> devices) throws U2fBadConfigurationException {
        if (this.validateAppId) {
            AppId.checkIsValid(appId);
        }
        return new RegisterRequestData(appId, devices, this.primitives, this.challengeGenerator);
    }

    public SignRequestData startSignature(String appId, Iterable<? extends DeviceRegistration> devices) throws U2fBadConfigurationException, NoEligibleDevicesException {
        if (this.validateAppId) {
            AppId.checkIsValid(appId);
        }
        return new SignRequestData(appId, devices, this.primitives, this.challengeGenerator);
    }

    public DeviceRegistration finishRegistration(RegisterRequestData registerRequestData, RegisterResponse response) throws U2fRegistrationException {
        return this.finishRegistration(registerRequestData, response, null);
    }

    public DeviceRegistration finishRegistration(RegisterRequestData registerRequestData, RegisterResponse response, Set<String> facets) throws U2fRegistrationException {
        return this.primitives.finishRegistration(registerRequestData.getRegisterRequest(response), response, facets);
    }

    public DeviceRegistration finishSignature(SignRequestData signRequestData, SignResponse response, Iterable<? extends DeviceRegistration> devices) throws U2fAuthenticationException {
        return this.finishSignature(signRequestData, response, devices, null);
    }

    public DeviceRegistration finishSignature(SignRequestData signRequestData, SignResponse response, Iterable<? extends DeviceRegistration> devices, Set<String> facets) throws U2fAuthenticationException {
        try {
            final SignRequest request = signRequestData.getSignRequest(response);
            DeviceRegistration device = (DeviceRegistration)Iterables.find(devices, (Predicate)new Predicate<DeviceRegistration>(){

                public boolean apply(DeviceRegistration input) {
                    return Objects.equal((Object)request.getKeyHandle(), (Object)input.getKeyHandle());
                }
            });
            if (device.isCompromised()) {
                throw new DeviceCompromisedException(device, "The device is marked as possibly compromised, and cannot make trusted signatures.");
            }
            this.primitives.finishSignature(request, response, device, facets);
            return device;
        }
        catch (U2fBadInputException e) {
            throw new U2fAuthenticationException("finishSignature failed", e);
        }
    }
}

