/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.yubico.u2f.U2fException;
import com.yubico.u2f.data.DataObject;
import com.yubico.u2f.data.messages.ClientData;

public class AuthenticateResponse
extends DataObject {
    private final String clientData;
    private final String signatureData;
    private final String challenge;

    public AuthenticateResponse(String clientData, String signatureData, String challenge) {
        this.clientData = (String)Preconditions.checkNotNull((Object)clientData);
        this.signatureData = (String)Preconditions.checkNotNull((Object)signatureData);
        this.challenge = (String)Preconditions.checkNotNull((Object)challenge);
    }

    public ClientData getClientData() throws U2fException {
        return new ClientData(this.clientData);
    }

    public String getSignatureData() {
        return this.signatureData;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientData, this.signatureData, this.challenge});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticateResponse other = (AuthenticateResponse)obj;
        if (this.clientData == null ? other.clientData != null : !this.clientData.equals(other.clientData)) {
            return false;
        }
        if (this.challenge == null ? other.challenge != null : !this.challenge.equals(other.challenge)) {
            return false;
        }
        return !(this.signatureData == null ? other.signatureData != null : !this.signatureData.equals(other.signatureData));
    }

    public static AuthenticateResponse fromJson(String json) {
        Gson gson = new Gson();
        return (AuthenticateResponse)gson.fromJson(json, AuthenticateResponse.class);
    }
}

